# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "billing account transaction list",
)
class List(AAZCommand):
    """List the billed and unbilled transactions by billing account name for given start and end date. Transactions include purchases, refunds and Azure usage charges. Unbilled transactions are listed under pending invoice ID and do not include tax. Tax is added to the amount once an invoice is generated.
    """

    _aaz_info = {
        "version": "2019-10-01-preview",
        "resources": [
            ["mgmt-plane", "/providers/microsoft.billing/billingaccounts/{}/transactions", "2019-10-01-preview"],
        ]
    }

    AZ_SUPPORT_PAGINATION = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_paging(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.billing_account_name = AAZStrArg(
            options=["--billing-account-name"],
            help="The ID that uniquely identifies a billing account.",
            required=True,
        )
        _args_schema.filter = AAZStrArg(
            options=["--filter"],
            help="May be used to filter by transaction type. The filter supports 'eq', 'lt', 'gt', 'le', 'ge', and 'and'. It does not currently support 'ne', 'or', or 'not'. Tag filter is a key value pair string where key and value are separated by a colon (:).",
        )
        _args_schema.period_end_date = AAZStrArg(
            options=["--period-end-date"],
            help="The end date to fetch the transactions. The date should be specified in MM-DD-YYYY format.",
            required=True,
        )
        _args_schema.period_start_date = AAZStrArg(
            options=["--period-start-date"],
            help="The start date to fetch the transactions. The date should be specified in MM-DD-YYYY format.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.TransactionsListByBillingAccount(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        next_link = self.deserialize_output(self.ctx.vars.instance.next_link)
        return result, next_link

    class TransactionsListByBillingAccount(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/transactions",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "billingAccountName", self.ctx.args.billing_account_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$filter", self.ctx.args.filter,
                ),
                **self.serialize_query_param(
                    "periodEndDate", self.ctx.args.period_end_date,
                    required=True,
                ),
                **self.serialize_query_param(
                    "periodStartDate", self.ctx.args.period_start_date,
                    required=True,
                ),
                **self.serialize_query_param(
                    "api-version", "2019-10-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
                flags={"read_only": True},
            )
            _schema_on_200.value = AAZListType(
                flags={"read_only": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.azure_credit_applied = AAZObjectType(
                serialized_name="azureCreditApplied",
            )
            _ListHelper._build_schema_amount_read(properties.azure_credit_applied)
            properties.billing_currency = AAZStrType(
                serialized_name="billingCurrency",
                flags={"read_only": True},
            )
            properties.billing_profile_display_name = AAZStrType(
                serialized_name="billingProfileDisplayName",
                flags={"read_only": True},
            )
            properties.billing_profile_id = AAZStrType(
                serialized_name="billingProfileId",
                flags={"read_only": True},
            )
            properties.customer_display_name = AAZStrType(
                serialized_name="customerDisplayName",
                flags={"read_only": True},
            )
            properties.customer_id = AAZStrType(
                serialized_name="customerId",
                flags={"read_only": True},
            )
            properties.date = AAZStrType(
                flags={"read_only": True},
            )
            properties.discount = AAZFloatType(
                flags={"read_only": True},
            )
            properties.effective_price = AAZObjectType(
                serialized_name="effectivePrice",
            )
            _ListHelper._build_schema_amount_read(properties.effective_price)
            properties.exchange_rate = AAZFloatType(
                serialized_name="exchangeRate",
                flags={"read_only": True},
            )
            properties.invoice = AAZStrType(
                flags={"read_only": True},
            )
            properties.invoice_section_display_name = AAZStrType(
                serialized_name="invoiceSectionDisplayName",
                flags={"read_only": True},
            )
            properties.invoice_section_id = AAZStrType(
                serialized_name="invoiceSectionId",
                flags={"read_only": True},
            )
            properties.kind = AAZStrType()
            properties.market_price = AAZObjectType(
                serialized_name="marketPrice",
            )
            _ListHelper._build_schema_amount_read(properties.market_price)
            properties.order_id = AAZStrType(
                serialized_name="orderId",
                flags={"read_only": True},
            )
            properties.order_name = AAZStrType(
                serialized_name="orderName",
                flags={"read_only": True},
            )
            properties.pricing_currency = AAZStrType(
                serialized_name="pricingCurrency",
                flags={"read_only": True},
            )
            properties.product_description = AAZStrType(
                serialized_name="productDescription",
                flags={"read_only": True},
            )
            properties.product_family = AAZStrType(
                serialized_name="productFamily",
                flags={"read_only": True},
            )
            properties.product_type = AAZStrType(
                serialized_name="productType",
                flags={"read_only": True},
            )
            properties.product_type_id = AAZStrType(
                serialized_name="productTypeId",
                flags={"read_only": True},
            )
            properties.quantity = AAZIntType(
                flags={"read_only": True},
            )
            properties.service_period_end_date = AAZStrType(
                serialized_name="servicePeriodEndDate",
                flags={"read_only": True},
            )
            properties.service_period_start_date = AAZStrType(
                serialized_name="servicePeriodStartDate",
                flags={"read_only": True},
            )
            properties.sub_total = AAZObjectType(
                serialized_name="subTotal",
            )
            _ListHelper._build_schema_amount_read(properties.sub_total)
            properties.subscription_id = AAZStrType(
                serialized_name="subscriptionId",
                flags={"read_only": True},
            )
            properties.subscription_name = AAZStrType(
                serialized_name="subscriptionName",
                flags={"read_only": True},
            )
            properties.tax = AAZObjectType()
            _ListHelper._build_schema_amount_read(properties.tax)
            properties.transaction_amount = AAZObjectType(
                serialized_name="transactionAmount",
            )
            _ListHelper._build_schema_amount_read(properties.transaction_amount)
            properties.transaction_type = AAZStrType(
                serialized_name="transactionType",
            )
            properties.unit_of_measure = AAZStrType(
                serialized_name="unitOfMeasure",
                flags={"read_only": True},
            )
            properties.unit_type = AAZStrType(
                serialized_name="unitType",
                flags={"read_only": True},
            )
            properties.units = AAZFloatType(
                flags={"read_only": True},
            )

            return cls._schema_on_200


class _ListHelper:
    """Helper class for List"""

    _schema_amount_read = None

    @classmethod
    def _build_schema_amount_read(cls, _schema):
        if cls._schema_amount_read is not None:
            _schema.currency = cls._schema_amount_read.currency
            _schema.value = cls._schema_amount_read.value
            return

        cls._schema_amount_read = _schema_amount_read = AAZObjectType()

        amount_read = _schema_amount_read
        amount_read.currency = AAZStrType(
            flags={"read_only": True},
        )
        amount_read.value = AAZFloatType()

        _schema.currency = cls._schema_amount_read.currency
        _schema.value = cls._schema_amount_read.value


__all__ = ["List"]
