/***************************************************************************
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \___|\___/|_| \_\_____|
 *
 * Copyright (C) Daniel Stenberg, <daniel@haxx.se>, et al.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution. The terms
 * are also available at https://curl.se/docs/copyright.html.
 *
 * You may opt to use, copy, modify, merge, publish, distribute and/or sell
 * copies of the Software, and permit persons to whom the Software is
 * furnished to do so, under the terms of the COPYING file.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 * SPDX-License-Identifier: curl
 *
 ***************************************************************************/
#include "first.h"

struct t510_WriteThis {
  int counter;
};

static size_t t510_read_cb(char *ptr, size_t size, size_t nmemb, void *userp)
{
  static const char * const testpost[] = {
    "one",
    "two",
    "three",
    "and a final longer crap: four",
    NULL
  };

  struct t510_WriteThis *pooh = (struct t510_WriteThis *)userp;
  const char *data;

  if(size * nmemb < 1)
    return 0;

  data = testpost[pooh->counter];

  if(data) {
    size_t len = strlen(data);
    if(size * nmemb < len) {
      curl_mfprintf(stderr, "read buffer is too small to run test\n");
      return 0;
    }
    memcpy(ptr, data, len);
    pooh->counter++; /* advance pointer */
    return len;
  }
  return 0;                         /* no more data left to deliver */
}

static CURLcode test_lib510(const char *URL)
{
  CURL *curl;
  CURLcode result = CURLE_OK;
  struct curl_slist *slist = NULL;
  struct t510_WriteThis pooh;
  pooh.counter = 0;

  if(curl_global_init(CURL_GLOBAL_ALL) != CURLE_OK) {
    curl_mfprintf(stderr, "curl_global_init() failed\n");
    return TEST_ERR_MAJOR_BAD;
  }

  curl = curl_easy_init();
  if(!curl) {
    curl_mfprintf(stderr, "curl_easy_init() failed\n");
    curl_global_cleanup();
    return TEST_ERR_MAJOR_BAD;
  }

  slist = curl_slist_append(slist, "Transfer-Encoding: chunked");
  if(!slist) {
    curl_mfprintf(stderr, "curl_slist_append() failed\n");
    curl_easy_cleanup(curl);
    curl_global_cleanup();
    return TEST_ERR_MAJOR_BAD;
  }

  /* First set the URL that is about to receive our POST. */
  test_setopt(curl, CURLOPT_URL, URL);

  /* Now specify we want to POST data */
  test_setopt(curl, CURLOPT_POST, 1L);

  /* we want to use our own read function */
  test_setopt(curl, CURLOPT_READFUNCTION, t510_read_cb);

  /* pointer to pass to our read function */
  test_setopt(curl, CURLOPT_READDATA, &pooh);

  /* get verbose debug output please */
  test_setopt(curl, CURLOPT_VERBOSE, 1L);

  /* include headers in the output */
  test_setopt(curl, CURLOPT_HEADER, 1L);

  /* enforce chunked transfer by setting the header */
  test_setopt(curl, CURLOPT_HTTPHEADER, slist);

  if(testnum == 565) {
    test_setopt(curl, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST);
    test_setopt(curl, CURLOPT_USERPWD, "foo:bar");
  }

  /* Perform the request, result will get the return code */
  result = curl_easy_perform(curl);

test_cleanup:

  /* clean up the headers list */
  if(slist)
    curl_slist_free_all(slist);

  /* always cleanup */
  curl_easy_cleanup(curl);
  curl_global_cleanup();

  return result;
}
