/**
 * Furnace Tracker - multi-system chiptune tracker
 * Copyright (C) 2021-2025 tildearrow and contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _GA20_H
#define _GA20_H

#include "../dispatch.h"
#include "../../fixedQueue.h"
#include "../macroInt.h"
#include "sound/ga20/iremga20.h"

class DivPlatformGA20: public DivDispatch, public iremga20_intf {
  struct Channel: public SharedChannel<int> {
    int prevFreq;
    unsigned int audPos;
    int sample;
    bool volumeChanged, setPos;
    int resVol;
    int macroVolMul;
    Channel():
      SharedChannel<int>(255),
      prevFreq(-1),
      audPos(0),
      sample(-1),
      volumeChanged(false),
      setPos(false),
      resVol(255),
      macroVolMul(64) {}
  };
  Channel chan[4];
  DivDispatchOscBuffer* oscBuf[4];
  bool isMuted[4];
  struct QueuedWrite {
    unsigned char addr;
    unsigned char val;
    QueuedWrite(): addr(0), val(0) {}
    QueuedWrite(unsigned char a, unsigned char v):
      addr(a),
      val(v) {}
  };
  FixedQueue<QueuedWrite,256> writes;
  unsigned int* sampleOffGA20;
  bool* sampleLoaded;

  int oldOut;

  short* ga20Buf[4];
  size_t ga20BufLen;

  unsigned char* sampleMem;
  size_t sampleMemLen;
  iremga20_device ga20;
  DivMemoryComposition memCompo;
  unsigned char regPool[32];
  friend void putDispatchChip(void*,int);
  friend void putDispatchChan(void*,int,int);

  void chWrite(unsigned char ch, unsigned int addr, unsigned char val);
  public:
    virtual u8 read_byte(u32 address) override;
    virtual void acquireDirect(blip_buffer_t** bb, size_t len) override;
    virtual void acquire(short** buf, size_t len) override;
    virtual int dispatch(DivCommand c) override;
    virtual void* getChanState(int chan) override;
    virtual DivMacroInt* getChanMacroInt(int ch) override;
    virtual DivSamplePos getSamplePos(int ch) override;
    virtual DivDispatchOscBuffer* getOscBuffer(int chan) override;
    virtual unsigned char* getRegisterPool() override;
    virtual int getRegisterPoolSize() override;
    virtual void reset() override;
    virtual void forceIns() override;
    virtual void tick(bool sysTick=true) override;
    virtual void muteChannel(int ch, bool mute) override;
    virtual bool hasAcquireDirect() override;
    virtual int getOutputCount() override;
    virtual void notifyInsChange(int ins) override;
    virtual void notifyWaveChange(int wave) override;
    virtual void notifyInsDeletion(void* ins) override;
    virtual void setFlags(const DivConfig& flags) override;
    virtual void poke(unsigned int addr, unsigned short val) override;
    virtual void poke(std::vector<DivRegWrite>& wlist) override;
    virtual const char** getRegisterSheet() override;
    virtual const void* getSampleMem(int index = 0) override;
    virtual size_t getSampleMemCapacity(int index = 0) override;
    virtual size_t getSampleMemUsage(int index = 0) override;
    virtual bool isSampleLoaded(int index, int sample) override;
    virtual const DivMemoryComposition* getMemCompo(int index) override;
    virtual void renderSamples(int chipID) override;
    virtual int init(DivEngine* parent, int channels, int sugRate, const DivConfig& flags) override;
    virtual void quit() override;
    DivPlatformGA20();
    ~DivPlatformGA20();
};

#endif
