// Code generated by smithy-go-codegen DO NOT EDIT.

package backupstorage

import (
	"context"
	"fmt"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpDeleteObject struct {
}

func (*validateOpDeleteObject) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteObject) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteObjectInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteObjectInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetChunk struct {
}

func (*validateOpGetChunk) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetChunk) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetChunkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetChunkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetObjectMetadata struct {
}

func (*validateOpGetObjectMetadata) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetObjectMetadata) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetObjectMetadataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetObjectMetadataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListChunks struct {
}

func (*validateOpListChunks) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListChunks) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListChunksInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListChunksInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListObjects struct {
}

func (*validateOpListObjects) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListObjects) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListObjectsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListObjectsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpNotifyObjectComplete struct {
}

func (*validateOpNotifyObjectComplete) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpNotifyObjectComplete) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*NotifyObjectCompleteInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpNotifyObjectCompleteInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutChunk struct {
}

func (*validateOpPutChunk) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutChunk) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutChunkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutChunkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutObject struct {
}

func (*validateOpPutObject) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutObject) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutObjectInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutObjectInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartObject struct {
}

func (*validateOpStartObject) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartObject) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartObjectInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartObjectInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpDeleteObjectValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteObject{}, middleware.After)
}

func addOpGetChunkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetChunk{}, middleware.After)
}

func addOpGetObjectMetadataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetObjectMetadata{}, middleware.After)
}

func addOpListChunksValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListChunks{}, middleware.After)
}

func addOpListObjectsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListObjects{}, middleware.After)
}

func addOpNotifyObjectCompleteValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpNotifyObjectComplete{}, middleware.After)
}

func addOpPutChunkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutChunk{}, middleware.After)
}

func addOpPutObjectValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutObject{}, middleware.After)
}

func addOpStartObjectValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartObject{}, middleware.After)
}

func validateOpDeleteObjectInput(v *DeleteObjectInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteObjectInput"}
	if v.BackupJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BackupJobId"))
	}
	if v.ObjectName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ObjectName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetChunkInput(v *GetChunkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetChunkInput"}
	if v.StorageJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageJobId"))
	}
	if v.ChunkToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChunkToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetObjectMetadataInput(v *GetObjectMetadataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetObjectMetadataInput"}
	if v.StorageJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageJobId"))
	}
	if v.ObjectToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ObjectToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListChunksInput(v *ListChunksInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListChunksInput"}
	if v.StorageJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageJobId"))
	}
	if v.ObjectToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ObjectToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListObjectsInput(v *ListObjectsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListObjectsInput"}
	if v.StorageJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageJobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpNotifyObjectCompleteInput(v *NotifyObjectCompleteInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NotifyObjectCompleteInput"}
	if v.BackupJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BackupJobId"))
	}
	if v.UploadId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UploadId"))
	}
	if v.ObjectChecksum == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ObjectChecksum"))
	}
	if len(v.ObjectChecksumAlgorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ObjectChecksumAlgorithm"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutChunkInput(v *PutChunkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutChunkInput"}
	if v.BackupJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BackupJobId"))
	}
	if v.UploadId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UploadId"))
	}
	if v.ChunkIndex == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChunkIndex"))
	}
	if v.Data == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Data"))
	}
	if v.Checksum == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Checksum"))
	}
	if len(v.ChecksumAlgorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ChecksumAlgorithm"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutObjectInput(v *PutObjectInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutObjectInput"}
	if v.BackupJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BackupJobId"))
	}
	if v.ObjectName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ObjectName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartObjectInput(v *StartObjectInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartObjectInput"}
	if v.BackupJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BackupJobId"))
	}
	if v.ObjectName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ObjectName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
