package network

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/network/mgmt/2015-06-15/network"

// ApplicationGatewayCookieBasedAffinity enumerates the values for application gateway cookie based affinity.
type ApplicationGatewayCookieBasedAffinity string

const (
	// Disabled ...
	Disabled ApplicationGatewayCookieBasedAffinity = "Disabled"
	// Enabled ...
	Enabled ApplicationGatewayCookieBasedAffinity = "Enabled"
)

// PossibleApplicationGatewayCookieBasedAffinityValues returns an array of possible values for the ApplicationGatewayCookieBasedAffinity const type.
func PossibleApplicationGatewayCookieBasedAffinityValues() []ApplicationGatewayCookieBasedAffinity {
	return []ApplicationGatewayCookieBasedAffinity{Disabled, Enabled}
}

// ApplicationGatewayOperationalState enumerates the values for application gateway operational state.
type ApplicationGatewayOperationalState string

const (
	// Running ...
	Running ApplicationGatewayOperationalState = "Running"
	// Starting ...
	Starting ApplicationGatewayOperationalState = "Starting"
	// Stopped ...
	Stopped ApplicationGatewayOperationalState = "Stopped"
	// Stopping ...
	Stopping ApplicationGatewayOperationalState = "Stopping"
)

// PossibleApplicationGatewayOperationalStateValues returns an array of possible values for the ApplicationGatewayOperationalState const type.
func PossibleApplicationGatewayOperationalStateValues() []ApplicationGatewayOperationalState {
	return []ApplicationGatewayOperationalState{Running, Starting, Stopped, Stopping}
}

// ApplicationGatewayProtocol enumerates the values for application gateway protocol.
type ApplicationGatewayProtocol string

const (
	// HTTP ...
	HTTP ApplicationGatewayProtocol = "Http"
	// HTTPS ...
	HTTPS ApplicationGatewayProtocol = "Https"
)

// PossibleApplicationGatewayProtocolValues returns an array of possible values for the ApplicationGatewayProtocol const type.
func PossibleApplicationGatewayProtocolValues() []ApplicationGatewayProtocol {
	return []ApplicationGatewayProtocol{HTTP, HTTPS}
}

// ApplicationGatewayRequestRoutingRuleType enumerates the values for application gateway request routing rule
// type.
type ApplicationGatewayRequestRoutingRuleType string

const (
	// Basic ...
	Basic ApplicationGatewayRequestRoutingRuleType = "Basic"
	// PathBasedRouting ...
	PathBasedRouting ApplicationGatewayRequestRoutingRuleType = "PathBasedRouting"
)

// PossibleApplicationGatewayRequestRoutingRuleTypeValues returns an array of possible values for the ApplicationGatewayRequestRoutingRuleType const type.
func PossibleApplicationGatewayRequestRoutingRuleTypeValues() []ApplicationGatewayRequestRoutingRuleType {
	return []ApplicationGatewayRequestRoutingRuleType{Basic, PathBasedRouting}
}

// ApplicationGatewaySkuName enumerates the values for application gateway sku name.
type ApplicationGatewaySkuName string

const (
	// StandardLarge ...
	StandardLarge ApplicationGatewaySkuName = "Standard_Large"
	// StandardMedium ...
	StandardMedium ApplicationGatewaySkuName = "Standard_Medium"
	// StandardSmall ...
	StandardSmall ApplicationGatewaySkuName = "Standard_Small"
)

// PossibleApplicationGatewaySkuNameValues returns an array of possible values for the ApplicationGatewaySkuName const type.
func PossibleApplicationGatewaySkuNameValues() []ApplicationGatewaySkuName {
	return []ApplicationGatewaySkuName{StandardLarge, StandardMedium, StandardSmall}
}

// ApplicationGatewayTier enumerates the values for application gateway tier.
type ApplicationGatewayTier string

const (
	// Standard ...
	Standard ApplicationGatewayTier = "Standard"
)

// PossibleApplicationGatewayTierValues returns an array of possible values for the ApplicationGatewayTier const type.
func PossibleApplicationGatewayTierValues() []ApplicationGatewayTier {
	return []ApplicationGatewayTier{Standard}
}

// AuthorizationUseStatus enumerates the values for authorization use status.
type AuthorizationUseStatus string

const (
	// Available ...
	Available AuthorizationUseStatus = "Available"
	// InUse ...
	InUse AuthorizationUseStatus = "InUse"
)

// PossibleAuthorizationUseStatusValues returns an array of possible values for the AuthorizationUseStatus const type.
func PossibleAuthorizationUseStatusValues() []AuthorizationUseStatus {
	return []AuthorizationUseStatus{Available, InUse}
}

// ExpressRouteCircuitPeeringAdvertisedPublicPrefixState enumerates the values for express route circuit
// peering advertised public prefix state.
type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState string

const (
	// Configured ...
	Configured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configured"
	// Configuring ...
	Configuring ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configuring"
	// NotConfigured ...
	NotConfigured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "NotConfigured"
	// ValidationNeeded ...
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "ValidationNeeded"
)

// PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues returns an array of possible values for the ExpressRouteCircuitPeeringAdvertisedPublicPrefixState const type.
func PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues() []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState {
	return []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState{Configured, Configuring, NotConfigured, ValidationNeeded}
}

// ExpressRouteCircuitPeeringState enumerates the values for express route circuit peering state.
type ExpressRouteCircuitPeeringState string

const (
	// ExpressRouteCircuitPeeringStateDisabled ...
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = "Disabled"
	// ExpressRouteCircuitPeeringStateEnabled ...
	ExpressRouteCircuitPeeringStateEnabled ExpressRouteCircuitPeeringState = "Enabled"
)

// PossibleExpressRouteCircuitPeeringStateValues returns an array of possible values for the ExpressRouteCircuitPeeringState const type.
func PossibleExpressRouteCircuitPeeringStateValues() []ExpressRouteCircuitPeeringState {
	return []ExpressRouteCircuitPeeringState{ExpressRouteCircuitPeeringStateDisabled, ExpressRouteCircuitPeeringStateEnabled}
}

// ExpressRouteCircuitPeeringType enumerates the values for express route circuit peering type.
type ExpressRouteCircuitPeeringType string

const (
	// AzurePrivatePeering ...
	AzurePrivatePeering ExpressRouteCircuitPeeringType = "AzurePrivatePeering"
	// AzurePublicPeering ...
	AzurePublicPeering ExpressRouteCircuitPeeringType = "AzurePublicPeering"
	// MicrosoftPeering ...
	MicrosoftPeering ExpressRouteCircuitPeeringType = "MicrosoftPeering"
)

// PossibleExpressRouteCircuitPeeringTypeValues returns an array of possible values for the ExpressRouteCircuitPeeringType const type.
func PossibleExpressRouteCircuitPeeringTypeValues() []ExpressRouteCircuitPeeringType {
	return []ExpressRouteCircuitPeeringType{AzurePrivatePeering, AzurePublicPeering, MicrosoftPeering}
}

// ExpressRouteCircuitSkuFamily enumerates the values for express route circuit sku family.
type ExpressRouteCircuitSkuFamily string

const (
	// MeteredData ...
	MeteredData ExpressRouteCircuitSkuFamily = "MeteredData"
	// UnlimitedData ...
	UnlimitedData ExpressRouteCircuitSkuFamily = "UnlimitedData"
)

// PossibleExpressRouteCircuitSkuFamilyValues returns an array of possible values for the ExpressRouteCircuitSkuFamily const type.
func PossibleExpressRouteCircuitSkuFamilyValues() []ExpressRouteCircuitSkuFamily {
	return []ExpressRouteCircuitSkuFamily{MeteredData, UnlimitedData}
}

// ExpressRouteCircuitSkuTier enumerates the values for express route circuit sku tier.
type ExpressRouteCircuitSkuTier string

const (
	// ExpressRouteCircuitSkuTierPremium ...
	ExpressRouteCircuitSkuTierPremium ExpressRouteCircuitSkuTier = "Premium"
	// ExpressRouteCircuitSkuTierStandard ...
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = "Standard"
)

// PossibleExpressRouteCircuitSkuTierValues returns an array of possible values for the ExpressRouteCircuitSkuTier const type.
func PossibleExpressRouteCircuitSkuTierValues() []ExpressRouteCircuitSkuTier {
	return []ExpressRouteCircuitSkuTier{ExpressRouteCircuitSkuTierPremium, ExpressRouteCircuitSkuTierStandard}
}

// IPAllocationMethod enumerates the values for ip allocation method.
type IPAllocationMethod string

const (
	// Dynamic ...
	Dynamic IPAllocationMethod = "Dynamic"
	// Static ...
	Static IPAllocationMethod = "Static"
)

// PossibleIPAllocationMethodValues returns an array of possible values for the IPAllocationMethod const type.
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return []IPAllocationMethod{Dynamic, Static}
}

// LoadDistribution enumerates the values for load distribution.
type LoadDistribution string

const (
	// Default ...
	Default LoadDistribution = "Default"
	// SourceIP ...
	SourceIP LoadDistribution = "SourceIP"
	// SourceIPProtocol ...
	SourceIPProtocol LoadDistribution = "SourceIPProtocol"
)

// PossibleLoadDistributionValues returns an array of possible values for the LoadDistribution const type.
func PossibleLoadDistributionValues() []LoadDistribution {
	return []LoadDistribution{Default, SourceIP, SourceIPProtocol}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// Failed ...
	Failed OperationStatus = "Failed"
	// InProgress ...
	InProgress OperationStatus = "InProgress"
	// Succeeded ...
	Succeeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{Failed, InProgress, Succeeded}
}

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP ...
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolTCP ...
	ProbeProtocolTCP ProbeProtocol = "Tcp"
)

// PossibleProbeProtocolValues returns an array of possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{ProbeProtocolHTTP, ProbeProtocolTCP}
}

// ProcessorArchitecture enumerates the values for processor architecture.
type ProcessorArchitecture string

const (
	// Amd64 ...
	Amd64 ProcessorArchitecture = "Amd64"
	// X86 ...
	X86 ProcessorArchitecture = "X86"
)

// PossibleProcessorArchitectureValues returns an array of possible values for the ProcessorArchitecture const type.
func PossibleProcessorArchitectureValues() []ProcessorArchitecture {
	return []ProcessorArchitecture{Amd64, X86}
}

// RouteNextHopType enumerates the values for route next hop type.
type RouteNextHopType string

const (
	// RouteNextHopTypeInternet ...
	RouteNextHopTypeInternet RouteNextHopType = "Internet"
	// RouteNextHopTypeNone ...
	RouteNextHopTypeNone RouteNextHopType = "None"
	// RouteNextHopTypeVirtualAppliance ...
	RouteNextHopTypeVirtualAppliance RouteNextHopType = "VirtualAppliance"
	// RouteNextHopTypeVirtualNetworkGateway ...
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = "VirtualNetworkGateway"
	// RouteNextHopTypeVnetLocal ...
	RouteNextHopTypeVnetLocal RouteNextHopType = "VnetLocal"
)

// PossibleRouteNextHopTypeValues returns an array of possible values for the RouteNextHopType const type.
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return []RouteNextHopType{RouteNextHopTypeInternet, RouteNextHopTypeNone, RouteNextHopTypeVirtualAppliance, RouteNextHopTypeVirtualNetworkGateway, RouteNextHopTypeVnetLocal}
}

// SecurityRuleAccess enumerates the values for security rule access.
type SecurityRuleAccess string

const (
	// Allow ...
	Allow SecurityRuleAccess = "Allow"
	// Deny ...
	Deny SecurityRuleAccess = "Deny"
)

// PossibleSecurityRuleAccessValues returns an array of possible values for the SecurityRuleAccess const type.
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return []SecurityRuleAccess{Allow, Deny}
}

// SecurityRuleDirection enumerates the values for security rule direction.
type SecurityRuleDirection string

const (
	// Inbound ...
	Inbound SecurityRuleDirection = "Inbound"
	// Outbound ...
	Outbound SecurityRuleDirection = "Outbound"
)

// PossibleSecurityRuleDirectionValues returns an array of possible values for the SecurityRuleDirection const type.
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return []SecurityRuleDirection{Inbound, Outbound}
}

// SecurityRuleProtocol enumerates the values for security rule protocol.
type SecurityRuleProtocol string

const (
	// Asterisk ...
	Asterisk SecurityRuleProtocol = "*"
	// TCP ...
	TCP SecurityRuleProtocol = "Tcp"
	// UDP ...
	UDP SecurityRuleProtocol = "Udp"
)

// PossibleSecurityRuleProtocolValues returns an array of possible values for the SecurityRuleProtocol const type.
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return []SecurityRuleProtocol{Asterisk, TCP, UDP}
}

// ServiceProviderProvisioningState enumerates the values for service provider provisioning state.
type ServiceProviderProvisioningState string

const (
	// Deprovisioning ...
	Deprovisioning ServiceProviderProvisioningState = "Deprovisioning"
	// NotProvisioned ...
	NotProvisioned ServiceProviderProvisioningState = "NotProvisioned"
	// Provisioned ...
	Provisioned ServiceProviderProvisioningState = "Provisioned"
	// Provisioning ...
	Provisioning ServiceProviderProvisioningState = "Provisioning"
)

// PossibleServiceProviderProvisioningStateValues returns an array of possible values for the ServiceProviderProvisioningState const type.
func PossibleServiceProviderProvisioningStateValues() []ServiceProviderProvisioningState {
	return []ServiceProviderProvisioningState{Deprovisioning, NotProvisioned, Provisioned, Provisioning}
}

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolTCP ...
	TransportProtocolTCP TransportProtocol = "Tcp"
	// TransportProtocolUDP ...
	TransportProtocolUDP TransportProtocol = "Udp"
)

// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TransportProtocolTCP, TransportProtocolUDP}
}

// VirtualNetworkGatewayConnectionStatus enumerates the values for virtual network gateway connection status.
type VirtualNetworkGatewayConnectionStatus string

const (
	// Connected ...
	Connected VirtualNetworkGatewayConnectionStatus = "Connected"
	// Connecting ...
	Connecting VirtualNetworkGatewayConnectionStatus = "Connecting"
	// NotConnected ...
	NotConnected VirtualNetworkGatewayConnectionStatus = "NotConnected"
	// Unknown ...
	Unknown VirtualNetworkGatewayConnectionStatus = "Unknown"
)

// PossibleVirtualNetworkGatewayConnectionStatusValues returns an array of possible values for the VirtualNetworkGatewayConnectionStatus const type.
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return []VirtualNetworkGatewayConnectionStatus{Connected, Connecting, NotConnected, Unknown}
}

// VirtualNetworkGatewayConnectionType enumerates the values for virtual network gateway connection type.
type VirtualNetworkGatewayConnectionType string

const (
	// ExpressRoute ...
	ExpressRoute VirtualNetworkGatewayConnectionType = "ExpressRoute"
	// IPsec ...
	IPsec VirtualNetworkGatewayConnectionType = "IPsec"
	// Vnet2Vnet ...
	Vnet2Vnet VirtualNetworkGatewayConnectionType = "Vnet2Vnet"
	// VPNClient ...
	VPNClient VirtualNetworkGatewayConnectionType = "VPNClient"
)

// PossibleVirtualNetworkGatewayConnectionTypeValues returns an array of possible values for the VirtualNetworkGatewayConnectionType const type.
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return []VirtualNetworkGatewayConnectionType{ExpressRoute, IPsec, Vnet2Vnet, VPNClient}
}

// VirtualNetworkGatewaySkuName enumerates the values for virtual network gateway sku name.
type VirtualNetworkGatewaySkuName string

const (
	// VirtualNetworkGatewaySkuNameBasic ...
	VirtualNetworkGatewaySkuNameBasic VirtualNetworkGatewaySkuName = "Basic"
	// VirtualNetworkGatewaySkuNameHighPerformance ...
	VirtualNetworkGatewaySkuNameHighPerformance VirtualNetworkGatewaySkuName = "HighPerformance"
	// VirtualNetworkGatewaySkuNameStandard ...
	VirtualNetworkGatewaySkuNameStandard VirtualNetworkGatewaySkuName = "Standard"
)

// PossibleVirtualNetworkGatewaySkuNameValues returns an array of possible values for the VirtualNetworkGatewaySkuName const type.
func PossibleVirtualNetworkGatewaySkuNameValues() []VirtualNetworkGatewaySkuName {
	return []VirtualNetworkGatewaySkuName{VirtualNetworkGatewaySkuNameBasic, VirtualNetworkGatewaySkuNameHighPerformance, VirtualNetworkGatewaySkuNameStandard}
}

// VirtualNetworkGatewaySkuTier enumerates the values for virtual network gateway sku tier.
type VirtualNetworkGatewaySkuTier string

const (
	// VirtualNetworkGatewaySkuTierBasic ...
	VirtualNetworkGatewaySkuTierBasic VirtualNetworkGatewaySkuTier = "Basic"
	// VirtualNetworkGatewaySkuTierHighPerformance ...
	VirtualNetworkGatewaySkuTierHighPerformance VirtualNetworkGatewaySkuTier = "HighPerformance"
	// VirtualNetworkGatewaySkuTierStandard ...
	VirtualNetworkGatewaySkuTierStandard VirtualNetworkGatewaySkuTier = "Standard"
)

// PossibleVirtualNetworkGatewaySkuTierValues returns an array of possible values for the VirtualNetworkGatewaySkuTier const type.
func PossibleVirtualNetworkGatewaySkuTierValues() []VirtualNetworkGatewaySkuTier {
	return []VirtualNetworkGatewaySkuTier{VirtualNetworkGatewaySkuTierBasic, VirtualNetworkGatewaySkuTierHighPerformance, VirtualNetworkGatewaySkuTierStandard}
}

// VirtualNetworkGatewayType enumerates the values for virtual network gateway type.
type VirtualNetworkGatewayType string

const (
	// VirtualNetworkGatewayTypeExpressRoute ...
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = "ExpressRoute"
	// VirtualNetworkGatewayTypeVpn ...
	VirtualNetworkGatewayTypeVpn VirtualNetworkGatewayType = "Vpn"
)

// PossibleVirtualNetworkGatewayTypeValues returns an array of possible values for the VirtualNetworkGatewayType const type.
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return []VirtualNetworkGatewayType{VirtualNetworkGatewayTypeExpressRoute, VirtualNetworkGatewayTypeVpn}
}

// VpnType enumerates the values for vpn type.
type VpnType string

const (
	// PolicyBased ...
	PolicyBased VpnType = "PolicyBased"
	// RouteBased ...
	RouteBased VpnType = "RouteBased"
)

// PossibleVpnTypeValues returns an array of possible values for the VpnType const type.
func PossibleVpnTypeValues() []VpnType {
	return []VpnType{PolicyBased, RouteBased}
}

// AddressSpace addressSpace contains an array of IP address ranges that can be used by subnets of the
// virtual network.
type AddressSpace struct {
	// AddressPrefixes - A list of address blocks reserved for this virtual network in CIDR notation.
	AddressPrefixes *[]string `json:"addressPrefixes,omitempty"`
}

// ApplicationGateway application gateway resource
type ApplicationGateway struct {
	autorest.Response                   `json:"-"`
	*ApplicationGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationGateway.
func (ag ApplicationGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ag.ApplicationGatewayPropertiesFormat != nil {
		objectMap["properties"] = ag.ApplicationGatewayPropertiesFormat
	}
	if ag.Etag != nil {
		objectMap["etag"] = ag.Etag
	}
	if ag.ID != nil {
		objectMap["id"] = ag.ID
	}
	if ag.Location != nil {
		objectMap["location"] = ag.Location
	}
	if ag.Tags != nil {
		objectMap["tags"] = ag.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGateway struct.
func (ag *ApplicationGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPropertiesFormat ApplicationGatewayPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				ag.ApplicationGatewayPropertiesFormat = &applicationGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ag.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ag.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ag.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ag.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ag.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ag.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendAddress backend address of an application gateway.
type ApplicationGatewayBackendAddress struct {
	// Fqdn - Fully qualified domain name (FQDN).
	Fqdn *string `json:"fqdn,omitempty"`
	// IPAddress - IP address
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ApplicationGatewayBackendAddressPool backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPool struct {
	*ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendAddressPool.
func (agbap ApplicationGatewayBackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat
	}
	if agbap.Name != nil {
		objectMap["name"] = agbap.Name
	}
	if agbap.Etag != nil {
		objectMap["etag"] = agbap.Etag
	}
	if agbap.ID != nil {
		objectMap["id"] = agbap.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendAddressPool struct.
func (agbap *ApplicationGatewayBackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendAddressPoolPropertiesFormat ApplicationGatewayBackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				agbap.ApplicationGatewayBackendAddressPoolPropertiesFormat = &applicationGatewayBackendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbap.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbap.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat properties of Backend Address Pool of an
// application gateway.
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - Collection of references to IPs defined in network interfaces.
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	// BackendAddresses - Backend addresses
	BackendAddresses *[]ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`
	// ProvisioningState - Provisioning state of the backend address pool resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayBackendHTTPSettings backend address pool settings of an application gateway.
type ApplicationGatewayBackendHTTPSettings struct {
	*ApplicationGatewayBackendHTTPSettingsPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayBackendHTTPSettings.
func (agbhs ApplicationGatewayBackendHTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat != nil {
		objectMap["properties"] = agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat
	}
	if agbhs.Name != nil {
		objectMap["name"] = agbhs.Name
	}
	if agbhs.Etag != nil {
		objectMap["etag"] = agbhs.Etag
	}
	if agbhs.ID != nil {
		objectMap["id"] = agbhs.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayBackendHTTPSettings struct.
func (agbhs *ApplicationGatewayBackendHTTPSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayBackendHTTPSettingsPropertiesFormat ApplicationGatewayBackendHTTPSettingsPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayBackendHTTPSettingsPropertiesFormat)
				if err != nil {
					return err
				}
				agbhs.ApplicationGatewayBackendHTTPSettingsPropertiesFormat = &applicationGatewayBackendHTTPSettingsPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agbhs.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agbhs.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agbhs.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayBackendHTTPSettingsPropertiesFormat properties of Backend address pool settings of an
// application gateway.
type ApplicationGatewayBackendHTTPSettingsPropertiesFormat struct {
	// Port - Port
	Port *int32 `json:"port,omitempty"`
	// Protocol - Protocol. Possible values are: 'Http' and 'Https'. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// CookieBasedAffinity - Cookie based affinity. Possible values are: 'Enabled' and 'Disabled'. Possible values include: 'Enabled', 'Disabled'
	CookieBasedAffinity ApplicationGatewayCookieBasedAffinity `json:"cookieBasedAffinity,omitempty"`
	// RequestTimeout - Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
	RequestTimeout *int32 `json:"requestTimeout,omitempty"`
	// Probe - Probe resource of an application gateway.
	Probe *SubResource `json:"probe,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the backend http settings resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendIPConfiguration frontend IP configuration of an application gateway.
type ApplicationGatewayFrontendIPConfiguration struct {
	*ApplicationGatewayFrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendIPConfiguration.
func (agfic ApplicationGatewayFrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat
	}
	if agfic.Name != nil {
		objectMap["name"] = agfic.Name
	}
	if agfic.Etag != nil {
		objectMap["etag"] = agfic.Etag
	}
	if agfic.ID != nil {
		objectMap["id"] = agfic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendIPConfiguration struct.
func (agfic *ApplicationGatewayFrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendIPConfigurationPropertiesFormat ApplicationGatewayFrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agfic.ApplicationGatewayFrontendIPConfigurationPropertiesFormat = &applicationGatewayFrontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayFrontendIPConfigurationPropertiesFormat properties of Frontend IP configuration of an
// application gateway.
type ApplicationGatewayFrontendIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - PrivateIPAddress of the network interface IP Configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - PrivateIP allocation method. Possible values are: 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - Reference of the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - Reference of the PublicIP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayFrontendPort frontend port of an application gateway.
type ApplicationGatewayFrontendPort struct {
	*ApplicationGatewayFrontendPortPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayFrontendPort.
func (agfp ApplicationGatewayFrontendPort) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agfp.ApplicationGatewayFrontendPortPropertiesFormat != nil {
		objectMap["properties"] = agfp.ApplicationGatewayFrontendPortPropertiesFormat
	}
	if agfp.Name != nil {
		objectMap["name"] = agfp.Name
	}
	if agfp.Etag != nil {
		objectMap["etag"] = agfp.Etag
	}
	if agfp.ID != nil {
		objectMap["id"] = agfp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayFrontendPort struct.
func (agfp *ApplicationGatewayFrontendPort) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayFrontendPortPropertiesFormat ApplicationGatewayFrontendPortPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayFrontendPortPropertiesFormat)
				if err != nil {
					return err
				}
				agfp.ApplicationGatewayFrontendPortPropertiesFormat = &applicationGatewayFrontendPortPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agfp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agfp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agfp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayFrontendPortPropertiesFormat properties of Frontend port of an application gateway.
type ApplicationGatewayFrontendPortPropertiesFormat struct {
	// Port - Frontend port
	Port *int32 `json:"port,omitempty"`
	// ProvisioningState - Provisioning state of the frontend port resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayHTTPListener http listener of an application gateway.
type ApplicationGatewayHTTPListener struct {
	*ApplicationGatewayHTTPListenerPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayHTTPListener.
func (aghl ApplicationGatewayHTTPListener) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aghl.ApplicationGatewayHTTPListenerPropertiesFormat != nil {
		objectMap["properties"] = aghl.ApplicationGatewayHTTPListenerPropertiesFormat
	}
	if aghl.Name != nil {
		objectMap["name"] = aghl.Name
	}
	if aghl.Etag != nil {
		objectMap["etag"] = aghl.Etag
	}
	if aghl.ID != nil {
		objectMap["id"] = aghl.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayHTTPListener struct.
func (aghl *ApplicationGatewayHTTPListener) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayHTTPListenerPropertiesFormat ApplicationGatewayHTTPListenerPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayHTTPListenerPropertiesFormat)
				if err != nil {
					return err
				}
				aghl.ApplicationGatewayHTTPListenerPropertiesFormat = &applicationGatewayHTTPListenerPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aghl.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				aghl.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aghl.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayHTTPListenerPropertiesFormat properties of HTTP listener of an application gateway.
type ApplicationGatewayHTTPListenerPropertiesFormat struct {
	// FrontendIPConfiguration - Frontend IP configuration resource of an application gateway.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// FrontendPort - Frontend port resource of an application gateway.
	FrontendPort *SubResource `json:"frontendPort,omitempty"`
	// Protocol - Protocol. Possible values are: 'Http' and 'Https'. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// HostName - Host name of HTTP listener.
	HostName *string `json:"hostName,omitempty"`
	// SslCertificate - SSL certificate resource of an application gateway.
	SslCertificate *SubResource `json:"sslCertificate,omitempty"`
	// RequireServerNameIndication - Applicable only if protocol is https. Enables SNI for multi-hosting.
	RequireServerNameIndication *bool `json:"requireServerNameIndication,omitempty"`
	// ProvisioningState - Provisioning state of the HTTP listener resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayIPConfiguration IP configuration of an application gateway. Currently 1 public and 1
// private IP configuration is allowed.
type ApplicationGatewayIPConfiguration struct {
	*ApplicationGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayIPConfiguration.
func (agic ApplicationGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agic.ApplicationGatewayIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = agic.ApplicationGatewayIPConfigurationPropertiesFormat
	}
	if agic.Name != nil {
		objectMap["name"] = agic.Name
	}
	if agic.Etag != nil {
		objectMap["etag"] = agic.Etag
	}
	if agic.ID != nil {
		objectMap["id"] = agic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayIPConfiguration struct.
func (agic *ApplicationGatewayIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayIPConfigurationPropertiesFormat ApplicationGatewayIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				agic.ApplicationGatewayIPConfigurationPropertiesFormat = &applicationGatewayIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agic.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayIPConfigurationPropertiesFormat properties of IP configuration of an application
// gateway.
type ApplicationGatewayIPConfigurationPropertiesFormat struct {
	// Subnet - Reference of the subnet resource. A subnet from where application gateway gets its private address.
	Subnet *SubResource `json:"subnet,omitempty"`
	// ProvisioningState - Provisioning state of the application gateway subnet resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayListResult response for ListApplicationGateways API service call.
type ApplicationGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - List of an application gateways in a resource group.
	Value *[]ApplicationGateway `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGatewayListResultIterator provides access to a complete listing of ApplicationGateway values.
type ApplicationGatewayListResultIterator struct {
	i    int
	page ApplicationGatewayListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGatewayListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGatewayListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGatewayListResultIterator) Response() ApplicationGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGatewayListResultIterator) Value() ApplicationGateway {
	if !iter.page.NotDone() {
		return ApplicationGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGatewayListResultIterator type.
func NewApplicationGatewayListResultIterator(page ApplicationGatewayListResultPage) ApplicationGatewayListResultIterator {
	return ApplicationGatewayListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aglr ApplicationGatewayListResult) IsEmpty() bool {
	return aglr.Value == nil || len(*aglr.Value) == 0
}

// applicationGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aglr ApplicationGatewayListResult) applicationGatewayListResultPreparer(ctx context.Context) (*http.Request, error) {
	if aglr.NextLink == nil || len(to.String(aglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aglr.NextLink)))
}

// ApplicationGatewayListResultPage contains a page of ApplicationGateway values.
type ApplicationGatewayListResultPage struct {
	fn   func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)
	aglr ApplicationGatewayListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGatewayListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGatewayListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.aglr)
	if err != nil {
		return err
	}
	page.aglr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGatewayListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGatewayListResultPage) NotDone() bool {
	return !page.aglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGatewayListResultPage) Response() ApplicationGatewayListResult {
	return page.aglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGatewayListResultPage) Values() []ApplicationGateway {
	if page.aglr.IsEmpty() {
		return nil
	}
	return *page.aglr.Value
}

// Creates a new instance of the ApplicationGatewayListResultPage type.
func NewApplicationGatewayListResultPage(getNextPage func(context.Context, ApplicationGatewayListResult) (ApplicationGatewayListResult, error)) ApplicationGatewayListResultPage {
	return ApplicationGatewayListResultPage{fn: getNextPage}
}

// ApplicationGatewayPathRule path rule of URL path map of an application gateway.
type ApplicationGatewayPathRule struct {
	*ApplicationGatewayPathRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayPathRule.
func (agpr ApplicationGatewayPathRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpr.ApplicationGatewayPathRulePropertiesFormat != nil {
		objectMap["properties"] = agpr.ApplicationGatewayPathRulePropertiesFormat
	}
	if agpr.Name != nil {
		objectMap["name"] = agpr.Name
	}
	if agpr.Etag != nil {
		objectMap["etag"] = agpr.Etag
	}
	if agpr.ID != nil {
		objectMap["id"] = agpr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayPathRule struct.
func (agpr *ApplicationGatewayPathRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayPathRulePropertiesFormat ApplicationGatewayPathRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayPathRulePropertiesFormat)
				if err != nil {
					return err
				}
				agpr.ApplicationGatewayPathRulePropertiesFormat = &applicationGatewayPathRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agpr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agpr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agpr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayPathRulePropertiesFormat properties of probe of an application gateway.
type ApplicationGatewayPathRulePropertiesFormat struct {
	// Paths - Path rules of URL path map.
	Paths *[]string `json:"paths,omitempty"`
	// BackendAddressPool - Backend address pool resource of URL path map.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Backend http settings resource of URL path map.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// ProvisioningState - Path rule of URL path map resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayProbe probe of the application gateway.
type ApplicationGatewayProbe struct {
	*ApplicationGatewayProbePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayProbe.
func (agp ApplicationGatewayProbe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agp.ApplicationGatewayProbePropertiesFormat != nil {
		objectMap["properties"] = agp.ApplicationGatewayProbePropertiesFormat
	}
	if agp.Name != nil {
		objectMap["name"] = agp.Name
	}
	if agp.Etag != nil {
		objectMap["etag"] = agp.Etag
	}
	if agp.ID != nil {
		objectMap["id"] = agp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayProbe struct.
func (agp *ApplicationGatewayProbe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayProbePropertiesFormat ApplicationGatewayProbePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayProbePropertiesFormat)
				if err != nil {
					return err
				}
				agp.ApplicationGatewayProbePropertiesFormat = &applicationGatewayProbePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agp.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayProbePropertiesFormat properties of probe of an application gateway.
type ApplicationGatewayProbePropertiesFormat struct {
	// Protocol - Protocol. Possible values are: 'Http' and 'Https'. Possible values include: 'HTTP', 'HTTPS'
	Protocol ApplicationGatewayProtocol `json:"protocol,omitempty"`
	// Host - Host name to send the probe to.
	Host *string `json:"host,omitempty"`
	// Path - Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>
	Path *string `json:"path,omitempty"`
	// Interval - The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
	Interval *int32 `json:"interval,omitempty"`
	// Timeout - the probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// UnhealthyThreshold - The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
	UnhealthyThreshold *int32 `json:"unhealthyThreshold,omitempty"`
	// ProvisioningState - Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayPropertiesFormat properties of the application gateway.
type ApplicationGatewayPropertiesFormat struct {
	// Sku - SKU of the application gateway resource.
	Sku *ApplicationGatewaySku `json:"sku,omitempty"`
	// OperationalState - READ-ONLY; Operational state of the application gateway resource. Possible values are: 'Stopped', 'Started', 'Running', and 'Stopping'. Possible values include: 'Stopped', 'Starting', 'Running', 'Stopping'
	OperationalState ApplicationGatewayOperationalState `json:"operationalState,omitempty"`
	// GatewayIPConfigurations - Gets or sets subnets of application gateway resource
	GatewayIPConfigurations *[]ApplicationGatewayIPConfiguration `json:"gatewayIPConfigurations,omitempty"`
	// SslCertificates - SSL certificates of the application gateway resource.
	SslCertificates *[]ApplicationGatewaySslCertificate `json:"sslCertificates,omitempty"`
	// FrontendIPConfigurations - Frontend IP addresses of the application gateway resource.
	FrontendIPConfigurations *[]ApplicationGatewayFrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// FrontendPorts - Frontend ports of the application gateway resource.
	FrontendPorts *[]ApplicationGatewayFrontendPort `json:"frontendPorts,omitempty"`
	// Probes - Probes of the application gateway resource.
	Probes *[]ApplicationGatewayProbe `json:"probes,omitempty"`
	// BackendAddressPools - Backend address pool of the application gateway resource.
	BackendAddressPools *[]ApplicationGatewayBackendAddressPool `json:"backendAddressPools,omitempty"`
	// BackendHTTPSettingsCollection - Backend http settings of the application gateway resource.
	BackendHTTPSettingsCollection *[]ApplicationGatewayBackendHTTPSettings `json:"backendHttpSettingsCollection,omitempty"`
	// HTTPListeners - Http listeners of the application gateway resource.
	HTTPListeners *[]ApplicationGatewayHTTPListener `json:"httpListeners,omitempty"`
	// URLPathMaps - URL path map of the application gateway resource.
	URLPathMaps *[]ApplicationGatewayURLPathMap `json:"urlPathMaps,omitempty"`
	// RequestRoutingRules - Request routing rules of the application gateway resource.
	RequestRoutingRules *[]ApplicationGatewayRequestRoutingRule `json:"requestRoutingRules,omitempty"`
	// ResourceGUID - Resource GUID property of the application gateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Provisioning state of the application gateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewayRequestRoutingRule request routing rule of an application gateway.
type ApplicationGatewayRequestRoutingRule struct {
	*ApplicationGatewayRequestRoutingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayRequestRoutingRule.
func (agrrr ApplicationGatewayRequestRoutingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat != nil {
		objectMap["properties"] = agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat
	}
	if agrrr.Name != nil {
		objectMap["name"] = agrrr.Name
	}
	if agrrr.Etag != nil {
		objectMap["etag"] = agrrr.Etag
	}
	if agrrr.ID != nil {
		objectMap["id"] = agrrr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayRequestRoutingRule struct.
func (agrrr *ApplicationGatewayRequestRoutingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayRequestRoutingRulePropertiesFormat ApplicationGatewayRequestRoutingRulePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayRequestRoutingRulePropertiesFormat)
				if err != nil {
					return err
				}
				agrrr.ApplicationGatewayRequestRoutingRulePropertiesFormat = &applicationGatewayRequestRoutingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agrrr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agrrr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agrrr.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayRequestRoutingRulePropertiesFormat properties of request routing rule of the
// application gateway.
type ApplicationGatewayRequestRoutingRulePropertiesFormat struct {
	// RuleType - Rule type. Possible values are: 'Basic' and 'PathBasedRouting'. Possible values include: 'Basic', 'PathBasedRouting'
	RuleType ApplicationGatewayRequestRoutingRuleType `json:"ruleType,omitempty"`
	// BackendAddressPool - Backend address pool resource of the application gateway.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// BackendHTTPSettings - Frontend port resource of the application gateway.
	BackendHTTPSettings *SubResource `json:"backendHttpSettings,omitempty"`
	// HTTPListener - Http listener resource of the application gateway.
	HTTPListener *SubResource `json:"httpListener,omitempty"`
	// URLPathMap - URL path map resource of the application gateway.
	URLPathMap *SubResource `json:"urlPathMap,omitempty"`
	// ProvisioningState - Provisioning state of the request routing rule resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationGatewaysCreateOrUpdateFuture) Result(client ApplicationGatewaysClient) (ag ApplicationGateway, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ag.Response.Response, err = future.GetResult(sender); err == nil && ag.Response.Response.StatusCode != http.StatusNoContent {
		ag, err = client.CreateOrUpdateResponder(ag.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysCreateOrUpdateFuture", "Result", ag.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationGatewaysDeleteFuture) Result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationGatewaySku SKU of application gateway
type ApplicationGatewaySku struct {
	// Name - Name of an application gateway SKU. Possible values are: 'Standard_Small', 'Standard_Medium', 'Standard_Large', 'WAF_Medium', and 'WAF_Large'. Possible values include: 'StandardSmall', 'StandardMedium', 'StandardLarge'
	Name ApplicationGatewaySkuName `json:"name,omitempty"`
	// Tier - Tier of an application gateway. Possible values include: 'Standard'
	Tier ApplicationGatewayTier `json:"tier,omitempty"`
	// Capacity - Capacity (instance count) of an application gateway.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ApplicationGatewaySslCertificate SSL certificates of an application gateway.
type ApplicationGatewaySslCertificate struct {
	*ApplicationGatewaySslCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewaySslCertificate.
func (agsc ApplicationGatewaySslCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agsc.ApplicationGatewaySslCertificatePropertiesFormat != nil {
		objectMap["properties"] = agsc.ApplicationGatewaySslCertificatePropertiesFormat
	}
	if agsc.Name != nil {
		objectMap["name"] = agsc.Name
	}
	if agsc.Etag != nil {
		objectMap["etag"] = agsc.Etag
	}
	if agsc.ID != nil {
		objectMap["id"] = agsc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewaySslCertificate struct.
func (agsc *ApplicationGatewaySslCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewaySslCertificatePropertiesFormat ApplicationGatewaySslCertificatePropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewaySslCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				agsc.ApplicationGatewaySslCertificatePropertiesFormat = &applicationGatewaySslCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agsc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agsc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agsc.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewaySslCertificatePropertiesFormat properties of SSL certificates of an application
// gateway.
type ApplicationGatewaySslCertificatePropertiesFormat struct {
	// Data - Base-64 encoded pfx certificate. Only applicable in PUT Request.
	Data *string `json:"data,omitempty"`
	// Password - Password for the pfx file specified in data. Only applicable in PUT request.
	Password *string `json:"password,omitempty"`
	// PublicCertData - Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
	PublicCertData *string `json:"publicCertData,omitempty"`
	// ProvisioningState - Provisioning state of the SSL certificate resource Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationGatewaysStartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationGatewaysStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationGatewaysStartFuture) Result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationGatewaysStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationGatewaysStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationGatewaysStopFuture) Result(client ApplicationGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ApplicationGatewaysStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.ApplicationGatewaysStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationGatewayURLPathMap urlPathMaps give a url path to the backend mapping information for
// PathBasedRouting.
type ApplicationGatewayURLPathMap struct {
	*ApplicationGatewayURLPathMapPropertiesFormat `json:"properties,omitempty"`
	// Name - Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGatewayURLPathMap.
func (agupm ApplicationGatewayURLPathMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agupm.ApplicationGatewayURLPathMapPropertiesFormat != nil {
		objectMap["properties"] = agupm.ApplicationGatewayURLPathMapPropertiesFormat
	}
	if agupm.Name != nil {
		objectMap["name"] = agupm.Name
	}
	if agupm.Etag != nil {
		objectMap["etag"] = agupm.Etag
	}
	if agupm.ID != nil {
		objectMap["id"] = agupm.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGatewayURLPathMap struct.
func (agupm *ApplicationGatewayURLPathMap) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGatewayURLPathMapPropertiesFormat ApplicationGatewayURLPathMapPropertiesFormat
				err = json.Unmarshal(*v, &applicationGatewayURLPathMapPropertiesFormat)
				if err != nil {
					return err
				}
				agupm.ApplicationGatewayURLPathMapPropertiesFormat = &applicationGatewayURLPathMapPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agupm.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				agupm.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agupm.ID = &ID
			}
		}
	}

	return nil
}

// ApplicationGatewayURLPathMapPropertiesFormat properties of UrlPathMap of the application gateway.
type ApplicationGatewayURLPathMapPropertiesFormat struct {
	// DefaultBackendAddressPool - Default backend address pool resource of URL path map.
	DefaultBackendAddressPool *SubResource `json:"defaultBackendAddressPool,omitempty"`
	// DefaultBackendHTTPSettings - Default backend http settings resource of URL path map.
	DefaultBackendHTTPSettings *SubResource `json:"defaultBackendHttpSettings,omitempty"`
	// PathRules - Path rule of URL path map resource.
	PathRules *[]ApplicationGatewayPathRule `json:"pathRules,omitempty"`
	// ProvisioningState - Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// AuthorizationListResult response for ListAuthorizations API service call retrieves all authorizations
// that belongs to an ExpressRouteCircuit.
type AuthorizationListResult struct {
	autorest.Response `json:"-"`
	// Value - The authorizations in an ExpressRoute Circuit.
	Value *[]ExpressRouteCircuitAuthorization `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationListResultIterator provides access to a complete listing of
// ExpressRouteCircuitAuthorization values.
type AuthorizationListResultIterator struct {
	i    int
	page AuthorizationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AuthorizationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationListResultIterator) Response() AuthorizationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationListResultIterator) Value() ExpressRouteCircuitAuthorization {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitAuthorization{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AuthorizationListResultIterator type.
func NewAuthorizationListResultIterator(page AuthorizationListResultPage) AuthorizationListResultIterator {
	return AuthorizationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AuthorizationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// authorizationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AuthorizationListResult) authorizationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if alr.NextLink == nil || len(to.String(alr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AuthorizationListResultPage contains a page of ExpressRouteCircuitAuthorization values.
type AuthorizationListResultPage struct {
	fn  func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)
	alr AuthorizationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AuthorizationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationListResultPage) Response() AuthorizationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationListResultPage) Values() []ExpressRouteCircuitAuthorization {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AuthorizationListResultPage type.
func NewAuthorizationListResultPage(getNextPage func(context.Context, AuthorizationListResult) (AuthorizationListResult, error)) AuthorizationListResultPage {
	return AuthorizationListResultPage{fn: getNextPage}
}

// AuthorizationPropertiesFormat ...
type AuthorizationPropertiesFormat struct {
	// AuthorizationKey - The authorization key.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`
	// AuthorizationUseStatus - AuthorizationUseStatus. Possible values are: 'Available' and 'InUse'. Possible values include: 'Available', 'InUse'
	AuthorizationUseStatus AuthorizationUseStatus `json:"authorizationUseStatus,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// AzureAsyncOperationResult the response body contains the status of the specified asynchronous operation,
// indicating whether it has succeeded, is in progress, or has failed. Note that this status is distinct
// from the HTTP status code returned for the Get Operation Status operation itself. If the asynchronous
// operation succeeded, the response body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request
// and error information regarding the failure.
type AzureAsyncOperationResult struct {
	// Status - Status of the Azure async operation. Possible values are: 'InProgress', 'Succeeded', and 'Failed'. Possible values include: 'InProgress', 'Succeeded', 'Failed'
	Status OperationStatus `json:"status,omitempty"`
	Error  *Error          `json:"error,omitempty"`
}

// BackendAddressPool pool of backend IP addresses.
type BackendAddressPool struct {
	*BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendAddressPool.
func (bap BackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bap.BackendAddressPoolPropertiesFormat != nil {
		objectMap["properties"] = bap.BackendAddressPoolPropertiesFormat
	}
	if bap.Name != nil {
		objectMap["name"] = bap.Name
	}
	if bap.Etag != nil {
		objectMap["etag"] = bap.Etag
	}
	if bap.ID != nil {
		objectMap["id"] = bap.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendAddressPool struct.
func (bap *BackendAddressPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendAddressPoolPropertiesFormat BackendAddressPoolPropertiesFormat
				err = json.Unmarshal(*v, &backendAddressPoolPropertiesFormat)
				if err != nil {
					return err
				}
				bap.BackendAddressPoolPropertiesFormat = &backendAddressPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bap.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				bap.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bap.ID = &ID
			}
		}
	}

	return nil
}

// BackendAddressPoolPropertiesFormat properties of the backend address pool.
type BackendAddressPoolPropertiesFormat struct {
	// BackendIPConfigurations - Gets collection of references to IP addresses defined in network interfaces.
	BackendIPConfigurations *[]InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`
	// LoadBalancingRules - READ-ONLY; Gets load balancing rules that use this backend address pool.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// OutboundNatRule - Gets outbound rules that use this backend address pool.
	OutboundNatRule *SubResource `json:"outboundNatRule,omitempty"`
	// ProvisioningState - Get provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// BgpSettings ...
type BgpSettings struct {
	// Asn - Gets or sets this BGP speaker's ASN
	Asn *int64 `json:"asn,omitempty"`
	// BgpPeeringAddress - Gets or sets the BGP peering address and BGP identifier of this BGP speaker
	BgpPeeringAddress *string `json:"bgpPeeringAddress,omitempty"`
	// PeerWeight - Gets or sets the weight added to routes learned from this BGP speaker
	PeerWeight *int32 `json:"peerWeight,omitempty"`
}

// ConnectionResetSharedKey ...
type ConnectionResetSharedKey struct {
	autorest.Response `json:"-"`
	// KeyLength - The virtual network connection reset shared key length
	KeyLength *int64 `json:"keyLength,omitempty"`
}

// ConnectionSharedKey response for GetConnectionSharedKey API service call
type ConnectionSharedKey struct {
	autorest.Response `json:"-"`
	// Value - The virtual network connection shared key value
	Value *string `json:"value,omitempty"`
}

// ConnectionSharedKeyResult response for CheckConnectionSharedKey API service call
type ConnectionSharedKeyResult struct {
	autorest.Response `json:"-"`
	// Value - The virtual network connection shared key value
	Value *string `json:"value,omitempty"`
}

// DhcpOptions dhcpOptions contains an array of DNS servers available to VMs deployed in the virtual
// network. Standard DHCP option for a subnet overrides VNET DHCP options.
type DhcpOptions struct {
	// DNSServers - The list of DNS servers IP addresses.
	DNSServers *[]string `json:"dnsServers,omitempty"`
}

// DNSNameAvailabilityResult response for the CheckDnsNameAvailability API service call.
type DNSNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// Available - Domain availability (True/False).
	Available *bool `json:"available,omitempty"`
}

// Error error object properties
type Error struct {
	Code       *string         `json:"code,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
	Details    *[]ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
}

// ErrorDetails error details properties
type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Target  *string `json:"target,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ExpressRouteCircuit expressRouteCircuit resource
type ExpressRouteCircuit struct {
	autorest.Response `json:"-"`
	// Sku - The SKU.
	Sku                                  *ExpressRouteCircuitSku `json:"sku,omitempty"`
	*ExpressRouteCircuitPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuit.
func (erc ExpressRouteCircuit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erc.Sku != nil {
		objectMap["sku"] = erc.Sku
	}
	if erc.ExpressRouteCircuitPropertiesFormat != nil {
		objectMap["properties"] = erc.ExpressRouteCircuitPropertiesFormat
	}
	if erc.Etag != nil {
		objectMap["etag"] = erc.Etag
	}
	if erc.ID != nil {
		objectMap["id"] = erc.ID
	}
	if erc.Location != nil {
		objectMap["location"] = erc.Location
	}
	if erc.Tags != nil {
		objectMap["tags"] = erc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuit struct.
func (erc *ExpressRouteCircuit) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku ExpressRouteCircuitSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				erc.Sku = &sku
			}
		case "properties":
			if v != nil {
				var expressRouteCircuitPropertiesFormat ExpressRouteCircuitPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPropertiesFormat)
				if err != nil {
					return err
				}
				erc.ExpressRouteCircuitPropertiesFormat = &expressRouteCircuitPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				erc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				erc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				erc.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteCircuitArpTable the ARP table associated with the ExpressRouteCircuit.
type ExpressRouteCircuitArpTable struct {
	// IPAddress - The IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// MacAddress - The MAC address.
	MacAddress *string `json:"macAddress,omitempty"`
}

// ExpressRouteCircuitAuthorization authorization in an ExpressRouteCircuit resource.
type ExpressRouteCircuitAuthorization struct {
	autorest.Response              `json:"-"`
	*AuthorizationPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitAuthorization.
func (erca ExpressRouteCircuitAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erca.AuthorizationPropertiesFormat != nil {
		objectMap["properties"] = erca.AuthorizationPropertiesFormat
	}
	if erca.Name != nil {
		objectMap["name"] = erca.Name
	}
	if erca.Etag != nil {
		objectMap["etag"] = erca.Etag
	}
	if erca.ID != nil {
		objectMap["id"] = erca.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitAuthorization struct.
func (erca *ExpressRouteCircuitAuthorization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationPropertiesFormat AuthorizationPropertiesFormat
				err = json.Unmarshal(*v, &authorizationPropertiesFormat)
				if err != nil {
					return err
				}
				erca.AuthorizationPropertiesFormat = &authorizationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				erca.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				erca.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				erca.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture) Result(client ExpressRouteCircuitAuthorizationsClient) (erca ExpressRouteCircuitAuthorization, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erca.Response.Response, err = future.GetResult(sender); err == nil && erca.Response.Response.StatusCode != http.StatusNoContent {
		erca, err = client.CreateOrUpdateResponder(erca.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsCreateOrUpdateFuture", "Result", erca.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCircuitAuthorizationsDeleteFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCircuitAuthorizationsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExpressRouteCircuitAuthorizationsDeleteFuture) Result(client ExpressRouteCircuitAuthorizationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitAuthorizationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitAuthorizationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRouteCircuitListResult response for ListExpressRouteCircuit API service call.
type ExpressRouteCircuitListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteCircuits in a resource group.
	Value *[]ExpressRouteCircuit `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitListResultIterator provides access to a complete listing of ExpressRouteCircuit
// values.
type ExpressRouteCircuitListResultIterator struct {
	i    int
	page ExpressRouteCircuitListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitListResultIterator) Response() ExpressRouteCircuitListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitListResultIterator) Value() ExpressRouteCircuit {
	if !iter.page.NotDone() {
		return ExpressRouteCircuit{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitListResultIterator type.
func NewExpressRouteCircuitListResultIterator(page ExpressRouteCircuitListResultPage) ExpressRouteCircuitListResultIterator {
	return ExpressRouteCircuitListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erclr ExpressRouteCircuitListResult) IsEmpty() bool {
	return erclr.Value == nil || len(*erclr.Value) == 0
}

// expressRouteCircuitListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erclr ExpressRouteCircuitListResult) expressRouteCircuitListResultPreparer(ctx context.Context) (*http.Request, error) {
	if erclr.NextLink == nil || len(to.String(erclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erclr.NextLink)))
}

// ExpressRouteCircuitListResultPage contains a page of ExpressRouteCircuit values.
type ExpressRouteCircuitListResultPage struct {
	fn    func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)
	erclr ExpressRouteCircuitListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.erclr)
	if err != nil {
		return err
	}
	page.erclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitListResultPage) NotDone() bool {
	return !page.erclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitListResultPage) Response() ExpressRouteCircuitListResult {
	return page.erclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitListResultPage) Values() []ExpressRouteCircuit {
	if page.erclr.IsEmpty() {
		return nil
	}
	return *page.erclr.Value
}

// Creates a new instance of the ExpressRouteCircuitListResultPage type.
func NewExpressRouteCircuitListResultPage(getNextPage func(context.Context, ExpressRouteCircuitListResult) (ExpressRouteCircuitListResult, error)) ExpressRouteCircuitListResultPage {
	return ExpressRouteCircuitListResultPage{fn: getNextPage}
}

// ExpressRouteCircuitPeering peering in an ExpressRouteCircuit resource.
type ExpressRouteCircuitPeering struct {
	autorest.Response                           `json:"-"`
	*ExpressRouteCircuitPeeringPropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpressRouteCircuitPeering.
func (ercp ExpressRouteCircuitPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ercp.ExpressRouteCircuitPeeringPropertiesFormat != nil {
		objectMap["properties"] = ercp.ExpressRouteCircuitPeeringPropertiesFormat
	}
	if ercp.Name != nil {
		objectMap["name"] = ercp.Name
	}
	if ercp.Etag != nil {
		objectMap["etag"] = ercp.Etag
	}
	if ercp.ID != nil {
		objectMap["id"] = ercp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteCircuitPeering struct.
func (ercp *ExpressRouteCircuitPeering) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteCircuitPeeringPropertiesFormat ExpressRouteCircuitPeeringPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteCircuitPeeringPropertiesFormat)
				if err != nil {
					return err
				}
				ercp.ExpressRouteCircuitPeeringPropertiesFormat = &expressRouteCircuitPeeringPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ercp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ercp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ercp.ID = &ID
			}
		}
	}

	return nil
}

// ExpressRouteCircuitPeeringConfig specifies the peering configuration.
type ExpressRouteCircuitPeeringConfig struct {
	// AdvertisedPublicPrefixes - The reference of AdvertisedPublicPrefixes.
	AdvertisedPublicPrefixes *[]string `json:"advertisedPublicPrefixes,omitempty"`
	// AdvertisedPublicPrefixesState - AdvertisedPublicPrefixState of the Peering resource. Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'. Possible values include: 'NotConfigured', 'Configuring', 'Configured', 'ValidationNeeded'
	AdvertisedPublicPrefixesState ExpressRouteCircuitPeeringAdvertisedPublicPrefixState `json:"advertisedPublicPrefixesState,omitempty"`
	// CustomerASN - The CustomerASN of the peering.
	CustomerASN *int32 `json:"customerASN,omitempty"`
	// RoutingRegistryName - The RoutingRegistryName of the configuration.
	RoutingRegistryName *string `json:"routingRegistryName,omitempty"`
}

// ExpressRouteCircuitPeeringListResult response for ListPeering API service call retrieves all peerings
// that belong to an ExpressRouteCircuit.
type ExpressRouteCircuitPeeringListResult struct {
	autorest.Response `json:"-"`
	// Value - The peerings in an express route circuit.
	Value *[]ExpressRouteCircuitPeering `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitPeeringListResultIterator provides access to a complete listing of
// ExpressRouteCircuitPeering values.
type ExpressRouteCircuitPeeringListResultIterator struct {
	i    int
	page ExpressRouteCircuitPeeringListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitPeeringListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitPeeringListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitPeeringListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitPeeringListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitPeeringListResultIterator) Response() ExpressRouteCircuitPeeringListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitPeeringListResultIterator) Value() ExpressRouteCircuitPeering {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitPeering{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitPeeringListResultIterator type.
func NewExpressRouteCircuitPeeringListResultIterator(page ExpressRouteCircuitPeeringListResultPage) ExpressRouteCircuitPeeringListResultIterator {
	return ExpressRouteCircuitPeeringListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercplr ExpressRouteCircuitPeeringListResult) IsEmpty() bool {
	return ercplr.Value == nil || len(*ercplr.Value) == 0
}

// expressRouteCircuitPeeringListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercplr ExpressRouteCircuitPeeringListResult) expressRouteCircuitPeeringListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ercplr.NextLink == nil || len(to.String(ercplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercplr.NextLink)))
}

// ExpressRouteCircuitPeeringListResultPage contains a page of ExpressRouteCircuitPeering values.
type ExpressRouteCircuitPeeringListResultPage struct {
	fn     func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)
	ercplr ExpressRouteCircuitPeeringListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitPeeringListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitPeeringListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ercplr)
	if err != nil {
		return err
	}
	page.ercplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitPeeringListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitPeeringListResultPage) NotDone() bool {
	return !page.ercplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitPeeringListResultPage) Response() ExpressRouteCircuitPeeringListResult {
	return page.ercplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitPeeringListResultPage) Values() []ExpressRouteCircuitPeering {
	if page.ercplr.IsEmpty() {
		return nil
	}
	return *page.ercplr.Value
}

// Creates a new instance of the ExpressRouteCircuitPeeringListResultPage type.
func NewExpressRouteCircuitPeeringListResultPage(getNextPage func(context.Context, ExpressRouteCircuitPeeringListResult) (ExpressRouteCircuitPeeringListResult, error)) ExpressRouteCircuitPeeringListResultPage {
	return ExpressRouteCircuitPeeringListResultPage{fn: getNextPage}
}

// ExpressRouteCircuitPeeringPropertiesFormat ...
type ExpressRouteCircuitPeeringPropertiesFormat struct {
	// PeeringType - The PeeringType. Possible values are: 'AzurePublicPeering', 'AzurePrivatePeering', and 'MicrosoftPeering'. Possible values include: 'AzurePublicPeering', 'AzurePrivatePeering', 'MicrosoftPeering'
	PeeringType ExpressRouteCircuitPeeringType `json:"peeringType,omitempty"`
	// State - The state of peering. Possible values are: 'Disabled' and 'Enabled'. Possible values include: 'ExpressRouteCircuitPeeringStateDisabled', 'ExpressRouteCircuitPeeringStateEnabled'
	State ExpressRouteCircuitPeeringState `json:"state,omitempty"`
	// AzureASN - The Azure ASN.
	AzureASN *int32 `json:"azureASN,omitempty"`
	// PeerASN - The peer ASN.
	PeerASN *int32 `json:"peerASN,omitempty"`
	// PrimaryPeerAddressPrefix - The primary address prefix.
	PrimaryPeerAddressPrefix *string `json:"primaryPeerAddressPrefix,omitempty"`
	// SecondaryPeerAddressPrefix - The secondary address prefix.
	SecondaryPeerAddressPrefix *string `json:"secondaryPeerAddressPrefix,omitempty"`
	// PrimaryAzurePort - The primary port.
	PrimaryAzurePort *string `json:"primaryAzurePort,omitempty"`
	// SecondaryAzurePort - The secondary port.
	SecondaryAzurePort *string `json:"secondaryAzurePort,omitempty"`
	// SharedKey - The shared key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// VlanID - The VLAN ID.
	VlanID *int32 `json:"vlanId,omitempty"`
	// MicrosoftPeeringConfig - The Microsoft peering configuration.
	MicrosoftPeeringConfig *ExpressRouteCircuitPeeringConfig `json:"microsoftPeeringConfig,omitempty"`
	// Stats - Gets peering stats.
	Stats *ExpressRouteCircuitStats `json:"stats,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ExpressRouteCircuitPeeringsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ExpressRouteCircuitPeeringsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExpressRouteCircuitPeeringsCreateOrUpdateFuture) Result(client ExpressRouteCircuitPeeringsClient) (ercp ExpressRouteCircuitPeering, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ercp.Response.Response, err = future.GetResult(sender); err == nil && ercp.Response.Response.StatusCode != http.StatusNoContent {
		ercp, err = client.CreateOrUpdateResponder(ercp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsCreateOrUpdateFuture", "Result", ercp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCircuitPeeringsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitPeeringsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExpressRouteCircuitPeeringsDeleteFuture) Result(client ExpressRouteCircuitPeeringsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitPeeringsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitPeeringsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRouteCircuitPropertiesFormat properties of ExpressRouteCircuit.
type ExpressRouteCircuitPropertiesFormat struct {
	// CircuitProvisioningState - The CircuitProvisioningState state of the resource.
	CircuitProvisioningState *string `json:"circuitProvisioningState,omitempty"`
	// ServiceProviderProvisioningState - The ServiceProviderProvisioningState state of the resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and 'Deprovisioning'. Possible values include: 'NotProvisioned', 'Provisioning', 'Provisioned', 'Deprovisioning'
	ServiceProviderProvisioningState ServiceProviderProvisioningState `json:"serviceProviderProvisioningState,omitempty"`
	// Authorizations - The list of authorizations.
	Authorizations *[]ExpressRouteCircuitAuthorization `json:"authorizations,omitempty"`
	// Peerings - The list of peerings.
	Peerings *[]ExpressRouteCircuitPeering `json:"peerings,omitempty"`
	// ServiceKey - The ServiceKey.
	ServiceKey *string `json:"serviceKey,omitempty"`
	// ServiceProviderNotes - The ServiceProviderNotes.
	ServiceProviderNotes *string `json:"serviceProviderNotes,omitempty"`
	// ServiceProviderProperties - The ServiceProviderProperties.
	ServiceProviderProperties *ExpressRouteCircuitServiceProviderProperties `json:"serviceProviderProperties,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ExpressRouteCircuitRoutesTable the routes table associated with the ExpressRouteCircuit
type ExpressRouteCircuitRoutesTable struct {
	// AddressPrefix - Gets AddressPrefix.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NextHopType - Gets NextHopType. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
	// NextHopIP - Gets NextHopIP.
	NextHopIP *string `json:"nextHopIP,omitempty"`
	// AsPath - Gets AsPath.
	AsPath *string `json:"asPath,omitempty"`
}

// ExpressRouteCircuitsArpTableListResult response for ListArpTable associated with the Express Route
// Circuits API.
type ExpressRouteCircuitsArpTableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets list of the ARP table.
	Value *[]ExpressRouteCircuitArpTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsArpTableListResultIterator provides access to a complete listing of
// ExpressRouteCircuitArpTable values.
type ExpressRouteCircuitsArpTableListResultIterator struct {
	i    int
	page ExpressRouteCircuitsArpTableListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitsArpTableListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitsArpTableListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitsArpTableListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitsArpTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitsArpTableListResultIterator) Response() ExpressRouteCircuitsArpTableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitsArpTableListResultIterator) Value() ExpressRouteCircuitArpTable {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitArpTable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitsArpTableListResultIterator type.
func NewExpressRouteCircuitsArpTableListResultIterator(page ExpressRouteCircuitsArpTableListResultPage) ExpressRouteCircuitsArpTableListResultIterator {
	return ExpressRouteCircuitsArpTableListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercatlr ExpressRouteCircuitsArpTableListResult) IsEmpty() bool {
	return ercatlr.Value == nil || len(*ercatlr.Value) == 0
}

// expressRouteCircuitsArpTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercatlr ExpressRouteCircuitsArpTableListResult) expressRouteCircuitsArpTableListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ercatlr.NextLink == nil || len(to.String(ercatlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercatlr.NextLink)))
}

// ExpressRouteCircuitsArpTableListResultPage contains a page of ExpressRouteCircuitArpTable values.
type ExpressRouteCircuitsArpTableListResultPage struct {
	fn      func(context.Context, ExpressRouteCircuitsArpTableListResult) (ExpressRouteCircuitsArpTableListResult, error)
	ercatlr ExpressRouteCircuitsArpTableListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitsArpTableListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitsArpTableListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ercatlr)
	if err != nil {
		return err
	}
	page.ercatlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitsArpTableListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitsArpTableListResultPage) NotDone() bool {
	return !page.ercatlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitsArpTableListResultPage) Response() ExpressRouteCircuitsArpTableListResult {
	return page.ercatlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitsArpTableListResultPage) Values() []ExpressRouteCircuitArpTable {
	if page.ercatlr.IsEmpty() {
		return nil
	}
	return *page.ercatlr.Value
}

// Creates a new instance of the ExpressRouteCircuitsArpTableListResultPage type.
func NewExpressRouteCircuitsArpTableListResultPage(getNextPage func(context.Context, ExpressRouteCircuitsArpTableListResult) (ExpressRouteCircuitsArpTableListResult, error)) ExpressRouteCircuitsArpTableListResultPage {
	return ExpressRouteCircuitsArpTableListResultPage{fn: getNextPage}
}

// ExpressRouteCircuitsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExpressRouteCircuitsCreateOrUpdateFuture) Result(client ExpressRouteCircuitsClient) (erc ExpressRouteCircuit, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if erc.Response.Response, err = future.GetResult(sender); err == nil && erc.Response.Response.StatusCode != http.StatusNoContent {
		erc, err = client.CreateOrUpdateResponder(erc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsCreateOrUpdateFuture", "Result", erc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExpressRouteCircuitsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ExpressRouteCircuitsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExpressRouteCircuitsDeleteFuture) Result(client ExpressRouteCircuitsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.ExpressRouteCircuitsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.ExpressRouteCircuitsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExpressRouteCircuitServiceProviderProperties contains ServiceProviderProperties in an
// ExpressRouteCircuit.
type ExpressRouteCircuitServiceProviderProperties struct {
	// ServiceProviderName - The serviceProviderName.
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
	// PeeringLocation - The peering location.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// BandwidthInMbps - The BandwidthInMbps.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
}

// ExpressRouteCircuitSku contains SKU in an ExpressRouteCircuit.
type ExpressRouteCircuitSku struct {
	// Name - The name of the SKU.
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the SKU. Possible values are 'Standard' and 'Premium'. Possible values include: 'ExpressRouteCircuitSkuTierStandard', 'ExpressRouteCircuitSkuTierPremium'
	Tier ExpressRouteCircuitSkuTier `json:"tier,omitempty"`
	// Family - The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'. Possible values include: 'UnlimitedData', 'MeteredData'
	Family ExpressRouteCircuitSkuFamily `json:"family,omitempty"`
}

// ExpressRouteCircuitsRoutesTableListResult response for ListRoutesTable associated with the Express Route
// Circuits API.
type ExpressRouteCircuitsRoutesTableListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of routes table.
	Value *[]ExpressRouteCircuitRoutesTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsRoutesTableListResultIterator provides access to a complete listing of
// ExpressRouteCircuitRoutesTable values.
type ExpressRouteCircuitsRoutesTableListResultIterator struct {
	i    int
	page ExpressRouteCircuitsRoutesTableListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitsRoutesTableListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitsRoutesTableListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitsRoutesTableListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitsRoutesTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitsRoutesTableListResultIterator) Response() ExpressRouteCircuitsRoutesTableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitsRoutesTableListResultIterator) Value() ExpressRouteCircuitRoutesTable {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitRoutesTable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitsRoutesTableListResultIterator type.
func NewExpressRouteCircuitsRoutesTableListResultIterator(page ExpressRouteCircuitsRoutesTableListResultPage) ExpressRouteCircuitsRoutesTableListResultIterator {
	return ExpressRouteCircuitsRoutesTableListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercrtlr ExpressRouteCircuitsRoutesTableListResult) IsEmpty() bool {
	return ercrtlr.Value == nil || len(*ercrtlr.Value) == 0
}

// expressRouteCircuitsRoutesTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercrtlr ExpressRouteCircuitsRoutesTableListResult) expressRouteCircuitsRoutesTableListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ercrtlr.NextLink == nil || len(to.String(ercrtlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercrtlr.NextLink)))
}

// ExpressRouteCircuitsRoutesTableListResultPage contains a page of ExpressRouteCircuitRoutesTable values.
type ExpressRouteCircuitsRoutesTableListResultPage struct {
	fn      func(context.Context, ExpressRouteCircuitsRoutesTableListResult) (ExpressRouteCircuitsRoutesTableListResult, error)
	ercrtlr ExpressRouteCircuitsRoutesTableListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitsRoutesTableListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitsRoutesTableListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ercrtlr)
	if err != nil {
		return err
	}
	page.ercrtlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitsRoutesTableListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitsRoutesTableListResultPage) NotDone() bool {
	return !page.ercrtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitsRoutesTableListResultPage) Response() ExpressRouteCircuitsRoutesTableListResult {
	return page.ercrtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitsRoutesTableListResultPage) Values() []ExpressRouteCircuitRoutesTable {
	if page.ercrtlr.IsEmpty() {
		return nil
	}
	return *page.ercrtlr.Value
}

// Creates a new instance of the ExpressRouteCircuitsRoutesTableListResultPage type.
func NewExpressRouteCircuitsRoutesTableListResultPage(getNextPage func(context.Context, ExpressRouteCircuitsRoutesTableListResult) (ExpressRouteCircuitsRoutesTableListResult, error)) ExpressRouteCircuitsRoutesTableListResultPage {
	return ExpressRouteCircuitsRoutesTableListResultPage{fn: getNextPage}
}

// ExpressRouteCircuitsStatsListResult response for ListStats from Express Route Circuits Api service call
type ExpressRouteCircuitsStatsListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets List of Stats
	Value *[]ExpressRouteCircuitStats `json:"value,omitempty"`
	// NextLink - Gets the URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteCircuitsStatsListResultIterator provides access to a complete listing of
// ExpressRouteCircuitStats values.
type ExpressRouteCircuitsStatsListResultIterator struct {
	i    int
	page ExpressRouteCircuitsStatsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteCircuitsStatsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitsStatsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteCircuitsStatsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteCircuitsStatsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteCircuitsStatsListResultIterator) Response() ExpressRouteCircuitsStatsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteCircuitsStatsListResultIterator) Value() ExpressRouteCircuitStats {
	if !iter.page.NotDone() {
		return ExpressRouteCircuitStats{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteCircuitsStatsListResultIterator type.
func NewExpressRouteCircuitsStatsListResultIterator(page ExpressRouteCircuitsStatsListResultPage) ExpressRouteCircuitsStatsListResultIterator {
	return ExpressRouteCircuitsStatsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ercslr ExpressRouteCircuitsStatsListResult) IsEmpty() bool {
	return ercslr.Value == nil || len(*ercslr.Value) == 0
}

// expressRouteCircuitsStatsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ercslr ExpressRouteCircuitsStatsListResult) expressRouteCircuitsStatsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ercslr.NextLink == nil || len(to.String(ercslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ercslr.NextLink)))
}

// ExpressRouteCircuitsStatsListResultPage contains a page of ExpressRouteCircuitStats values.
type ExpressRouteCircuitsStatsListResultPage struct {
	fn     func(context.Context, ExpressRouteCircuitsStatsListResult) (ExpressRouteCircuitsStatsListResult, error)
	ercslr ExpressRouteCircuitsStatsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteCircuitsStatsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteCircuitsStatsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ercslr)
	if err != nil {
		return err
	}
	page.ercslr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteCircuitsStatsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteCircuitsStatsListResultPage) NotDone() bool {
	return !page.ercslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteCircuitsStatsListResultPage) Response() ExpressRouteCircuitsStatsListResult {
	return page.ercslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteCircuitsStatsListResultPage) Values() []ExpressRouteCircuitStats {
	if page.ercslr.IsEmpty() {
		return nil
	}
	return *page.ercslr.Value
}

// Creates a new instance of the ExpressRouteCircuitsStatsListResultPage type.
func NewExpressRouteCircuitsStatsListResultPage(getNextPage func(context.Context, ExpressRouteCircuitsStatsListResult) (ExpressRouteCircuitsStatsListResult, error)) ExpressRouteCircuitsStatsListResultPage {
	return ExpressRouteCircuitsStatsListResultPage{fn: getNextPage}
}

// ExpressRouteCircuitStats contains stats associated with the peering.
type ExpressRouteCircuitStats struct {
	// BytesIn - Gets BytesIn of the peering.
	BytesIn *int32 `json:"bytesIn,omitempty"`
	// BytesOut - Gets BytesOut of the peering.
	BytesOut *int32 `json:"bytesOut,omitempty"`
}

// ExpressRouteServiceProvider a ExpressRouteResourceProvider object.
type ExpressRouteServiceProvider struct {
	*ExpressRouteServiceProviderPropertiesFormat `json:"properties,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ExpressRouteServiceProvider.
func (ersp ExpressRouteServiceProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ersp.ExpressRouteServiceProviderPropertiesFormat != nil {
		objectMap["properties"] = ersp.ExpressRouteServiceProviderPropertiesFormat
	}
	if ersp.ID != nil {
		objectMap["id"] = ersp.ID
	}
	if ersp.Location != nil {
		objectMap["location"] = ersp.Location
	}
	if ersp.Tags != nil {
		objectMap["tags"] = ersp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExpressRouteServiceProvider struct.
func (ersp *ExpressRouteServiceProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expressRouteServiceProviderPropertiesFormat ExpressRouteServiceProviderPropertiesFormat
				err = json.Unmarshal(*v, &expressRouteServiceProviderPropertiesFormat)
				if err != nil {
					return err
				}
				ersp.ExpressRouteServiceProviderPropertiesFormat = &expressRouteServiceProviderPropertiesFormat
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ersp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ersp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ersp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ersp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ersp.Tags = tags
			}
		}
	}

	return nil
}

// ExpressRouteServiceProviderBandwidthsOffered contains bandwidths offered in ExpressRouteServiceProvider
// resources.
type ExpressRouteServiceProviderBandwidthsOffered struct {
	// OfferName - The OfferName.
	OfferName *string `json:"offerName,omitempty"`
	// ValueInMbps - The ValueInMbps.
	ValueInMbps *int32 `json:"valueInMbps,omitempty"`
}

// ExpressRouteServiceProviderListResult response for the ListExpressRouteServiceProvider API service call.
type ExpressRouteServiceProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of ExpressRouteResourceProvider resources.
	Value *[]ExpressRouteServiceProvider `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExpressRouteServiceProviderListResultIterator provides access to a complete listing of
// ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultIterator struct {
	i    int
	page ExpressRouteServiceProviderListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExpressRouteServiceProviderListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteServiceProviderListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExpressRouteServiceProviderListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExpressRouteServiceProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExpressRouteServiceProviderListResultIterator) Response() ExpressRouteServiceProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExpressRouteServiceProviderListResultIterator) Value() ExpressRouteServiceProvider {
	if !iter.page.NotDone() {
		return ExpressRouteServiceProvider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExpressRouteServiceProviderListResultIterator type.
func NewExpressRouteServiceProviderListResultIterator(page ExpressRouteServiceProviderListResultPage) ExpressRouteServiceProviderListResultIterator {
	return ExpressRouteServiceProviderListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ersplr ExpressRouteServiceProviderListResult) IsEmpty() bool {
	return ersplr.Value == nil || len(*ersplr.Value) == 0
}

// expressRouteServiceProviderListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ersplr ExpressRouteServiceProviderListResult) expressRouteServiceProviderListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ersplr.NextLink == nil || len(to.String(ersplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ersplr.NextLink)))
}

// ExpressRouteServiceProviderListResultPage contains a page of ExpressRouteServiceProvider values.
type ExpressRouteServiceProviderListResultPage struct {
	fn     func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)
	ersplr ExpressRouteServiceProviderListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExpressRouteServiceProviderListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExpressRouteServiceProviderListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ersplr)
	if err != nil {
		return err
	}
	page.ersplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExpressRouteServiceProviderListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExpressRouteServiceProviderListResultPage) NotDone() bool {
	return !page.ersplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExpressRouteServiceProviderListResultPage) Response() ExpressRouteServiceProviderListResult {
	return page.ersplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExpressRouteServiceProviderListResultPage) Values() []ExpressRouteServiceProvider {
	if page.ersplr.IsEmpty() {
		return nil
	}
	return *page.ersplr.Value
}

// Creates a new instance of the ExpressRouteServiceProviderListResultPage type.
func NewExpressRouteServiceProviderListResultPage(getNextPage func(context.Context, ExpressRouteServiceProviderListResult) (ExpressRouteServiceProviderListResult, error)) ExpressRouteServiceProviderListResultPage {
	return ExpressRouteServiceProviderListResultPage{fn: getNextPage}
}

// ExpressRouteServiceProviderPropertiesFormat properties of ExpressRouteServiceProvider.
type ExpressRouteServiceProviderPropertiesFormat struct {
	// PeeringLocations - Get a list of peering locations.
	PeeringLocations *[]string `json:"peeringLocations,omitempty"`
	// BandwidthsOffered - Gets bandwidths offered.
	BandwidthsOffered *[]ExpressRouteServiceProviderBandwidthsOffered `json:"bandwidthsOffered,omitempty"`
	// ProvisioningState - Gets the provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// FrontendIPConfiguration frontend IP address of the load balancer.
type FrontendIPConfiguration struct {
	*FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for FrontendIPConfiguration.
func (fic FrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fic.FrontendIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = fic.FrontendIPConfigurationPropertiesFormat
	}
	if fic.Name != nil {
		objectMap["name"] = fic.Name
	}
	if fic.Etag != nil {
		objectMap["etag"] = fic.Etag
	}
	if fic.ID != nil {
		objectMap["id"] = fic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FrontendIPConfiguration struct.
func (fic *FrontendIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var frontendIPConfigurationPropertiesFormat FrontendIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &frontendIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				fic.FrontendIPConfigurationPropertiesFormat = &frontendIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				fic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fic.ID = &ID
			}
		}
	}

	return nil
}

// FrontendIPConfigurationPropertiesFormat properties of Frontend IP Configuration of the load balancer.
type FrontendIPConfigurationPropertiesFormat struct {
	// InboundNatRules - Read only. Inbound rules URIs that use this frontend IP.
	InboundNatRules *[]SubResource `json:"inboundNatRules,omitempty"`
	// InboundNatPools - Read only. Inbound pools URIs that use this frontend IP.
	InboundNatPools *[]SubResource `json:"inboundNatPools,omitempty"`
	// OutboundNatRules - Read only. Outbound rules URIs that use this frontend IP.
	OutboundNatRules *[]SubResource `json:"outboundNatRules,omitempty"`
	// LoadBalancingRules - Gets load balancing rules URIs that use this frontend IP.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// PrivateIPAddress - The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - The reference of the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`
	// PublicIPAddress - The reference of the Public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// InboundNatPool inbound NAT pool of the load balancer.
type InboundNatPool struct {
	*InboundNatPoolPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatPool.
func (inp InboundNatPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inp.InboundNatPoolPropertiesFormat != nil {
		objectMap["properties"] = inp.InboundNatPoolPropertiesFormat
	}
	if inp.Name != nil {
		objectMap["name"] = inp.Name
	}
	if inp.Etag != nil {
		objectMap["etag"] = inp.Etag
	}
	if inp.ID != nil {
		objectMap["id"] = inp.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundNatPool struct.
func (inp *InboundNatPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatPoolPropertiesFormat InboundNatPoolPropertiesFormat
				err = json.Unmarshal(*v, &inboundNatPoolPropertiesFormat)
				if err != nil {
					return err
				}
				inp.InboundNatPoolPropertiesFormat = &inboundNatPoolPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inp.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inp.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inp.ID = &ID
			}
		}
	}

	return nil
}

// InboundNatPoolPropertiesFormat properties of Inbound NAT pool.
type InboundNatPoolPropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// Protocol - The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPortRangeStart - The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`
	// FrontendPortRangeEnd - The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`
	// BackendPort - The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// ProvisioningState - Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// InboundNatRule inbound NAT rule of the load balancer.
type InboundNatRule struct {
	*InboundNatRulePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundNatRule.
func (inr InboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if inr.InboundNatRulePropertiesFormat != nil {
		objectMap["properties"] = inr.InboundNatRulePropertiesFormat
	}
	if inr.Name != nil {
		objectMap["name"] = inr.Name
	}
	if inr.Etag != nil {
		objectMap["etag"] = inr.Etag
	}
	if inr.ID != nil {
		objectMap["id"] = inr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InboundNatRule struct.
func (inr *InboundNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var inboundNatRulePropertiesFormat InboundNatRulePropertiesFormat
				err = json.Unmarshal(*v, &inboundNatRulePropertiesFormat)
				if err != nil {
					return err
				}
				inr.InboundNatRulePropertiesFormat = &inboundNatRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				inr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				inr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				inr.ID = &ID
			}
		}
	}

	return nil
}

// InboundNatRulePropertiesFormat properties of the inbound NAT rule.
type InboundNatRulePropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendIPConfiguration - A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backed IP.
	BackendIPConfiguration *InterfaceIPConfiguration `json:"backendIPConfiguration,omitempty"`
	// Protocol - The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// FrontendPort - The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port used for the internal endpoint. Acceptable values range from 1 to 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Interface a network interface in a resource group.
type Interface struct {
	autorest.Response          `json:"-"`
	*InterfacePropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Interface.
func (i Interface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.InterfacePropertiesFormat != nil {
		objectMap["properties"] = i.InterfacePropertiesFormat
	}
	if i.Etag != nil {
		objectMap["etag"] = i.Etag
	}
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Location != nil {
		objectMap["location"] = i.Location
	}
	if i.Tags != nil {
		objectMap["tags"] = i.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Interface struct.
func (i *Interface) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfacePropertiesFormat InterfacePropertiesFormat
				err = json.Unmarshal(*v, &interfacePropertiesFormat)
				if err != nil {
					return err
				}
				i.InterfacePropertiesFormat = &interfacePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				i.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				i.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				i.Tags = tags
			}
		}
	}

	return nil
}

// InterfaceDNSSettings DNS settings of a network interface.
type InterfaceDNSSettings struct {
	// DNSServers - List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// AppliedDNSServers - If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
	AppliedDNSServers *[]string `json:"appliedDnsServers,omitempty"`
	// InternalDNSNameLabel - Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
	InternalDNSNameLabel *string `json:"internalDnsNameLabel,omitempty"`
	// InternalFqdn - Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
	InternalFqdn *string `json:"internalFqdn,omitempty"`
}

// InterfaceIPConfiguration iPConfiguration in a network interface.
type InterfaceIPConfiguration struct {
	*InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for InterfaceIPConfiguration.
func (iic InterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iic.InterfaceIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = iic.InterfaceIPConfigurationPropertiesFormat
	}
	if iic.Name != nil {
		objectMap["name"] = iic.Name
	}
	if iic.Etag != nil {
		objectMap["etag"] = iic.Etag
	}
	if iic.ID != nil {
		objectMap["id"] = iic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InterfaceIPConfiguration struct.
func (iic *InterfaceIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var interfaceIPConfigurationPropertiesFormat InterfaceIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &interfaceIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				iic.InterfaceIPConfigurationPropertiesFormat = &interfaceIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				iic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iic.ID = &ID
			}
		}
	}

	return nil
}

// InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
type InterfaceIPConfigurationPropertiesFormat struct {
	// LoadBalancerBackendAddressPools - The reference of LoadBalancerBackendAddressPool resource.
	LoadBalancerBackendAddressPools *[]BackendAddressPool `json:"loadBalancerBackendAddressPools,omitempty"`
	// LoadBalancerInboundNatRules - A list of references of LoadBalancerInboundNatRules.
	LoadBalancerInboundNatRules *[]InboundNatRule `json:"loadBalancerInboundNatRules,omitempty"`
	PrivateIPAddress            *string           `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	Subnet                    *Subnet            `json:"subnet,omitempty"`
	// Primary - Gets whether this is a primary customer address on the network interface.
	Primary           *bool            `json:"primary,omitempty"`
	PublicIPAddress   *PublicIPAddress `json:"publicIPAddress,omitempty"`
	ProvisioningState *string          `json:"provisioningState,omitempty"`
}

// InterfaceListResult response for the ListNetworkInterface API service call.
type InterfaceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of network interfaces in a resource group.
	Value *[]Interface `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InterfaceListResultIterator provides access to a complete listing of Interface values.
type InterfaceListResultIterator struct {
	i    int
	page InterfaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InterfaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InterfaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InterfaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InterfaceListResultIterator) Response() InterfaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InterfaceListResultIterator) Value() Interface {
	if !iter.page.NotDone() {
		return Interface{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InterfaceListResultIterator type.
func NewInterfaceListResultIterator(page InterfaceListResultPage) InterfaceListResultIterator {
	return InterfaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InterfaceListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// interfaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InterfaceListResult) interfaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ilr.NextLink == nil || len(to.String(ilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InterfaceListResultPage contains a page of Interface values.
type InterfaceListResultPage struct {
	fn  func(context.Context, InterfaceListResult) (InterfaceListResult, error)
	ilr InterfaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InterfaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InterfaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ilr)
	if err != nil {
		return err
	}
	page.ilr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InterfaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InterfaceListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InterfaceListResultPage) Response() InterfaceListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InterfaceListResultPage) Values() []Interface {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the InterfaceListResultPage type.
func NewInterfaceListResultPage(getNextPage func(context.Context, InterfaceListResult) (InterfaceListResult, error)) InterfaceListResultPage {
	return InterfaceListResultPage{fn: getNextPage}
}

// InterfacePropertiesFormat networkInterface properties.
type InterfacePropertiesFormat struct {
	// VirtualMachine - The reference of a virtual machine.
	VirtualMachine *SubResource `json:"virtualMachine,omitempty"`
	// NetworkSecurityGroup - The reference of the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`
	// IPConfigurations - A list of IPConfigurations of the network interface.
	IPConfigurations *[]InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`
	// DNSSettings - The DNS settings in network interface.
	DNSSettings *InterfaceDNSSettings `json:"dnsSettings,omitempty"`
	// MacAddress - The MAC address of the network interface.
	MacAddress *string `json:"macAddress,omitempty"`
	// Primary - Gets whether this is a primary network interface on a virtual machine.
	Primary *bool `json:"primary,omitempty"`
	// EnableIPForwarding - Indicates whether IP forwarding is enabled on this network interface.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`
	// ResourceGUID - The resource GUID property of the network interface resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// InterfacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InterfacesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InterfacesCreateOrUpdateFuture) Result(client InterfacesClient) (i Interface, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.InterfacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if i.Response.Response, err = future.GetResult(sender); err == nil && i.Response.Response.StatusCode != http.StatusNoContent {
		i, err = client.CreateOrUpdateResponder(i.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.InterfacesCreateOrUpdateFuture", "Result", i.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InterfacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InterfacesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InterfacesDeleteFuture) Result(client InterfacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.InterfacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.InterfacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IPConfiguration iPConfiguration
type IPConfiguration struct {
	*IPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for IPConfiguration.
func (ic IPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.IPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = ic.IPConfigurationPropertiesFormat
	}
	if ic.Name != nil {
		objectMap["name"] = ic.Name
	}
	if ic.Etag != nil {
		objectMap["etag"] = ic.Etag
	}
	if ic.ID != nil {
		objectMap["id"] = ic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IPConfiguration struct.
func (ic *IPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPConfigurationPropertiesFormat IPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &IPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				ic.IPConfigurationPropertiesFormat = &IPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ic.ID = &ID
			}
		}
	}

	return nil
}

// IPConfigurationPropertiesFormat properties of IP configuration.
type IPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP allocation method. Possible values are 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - The reference of the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`
	// PublicIPAddress - The reference of the public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LoadBalancer loadBalancer resource
type LoadBalancer struct {
	autorest.Response             `json:"-"`
	*LoadBalancerPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LoadBalancer.
func (lb LoadBalancer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lb.LoadBalancerPropertiesFormat != nil {
		objectMap["properties"] = lb.LoadBalancerPropertiesFormat
	}
	if lb.Etag != nil {
		objectMap["etag"] = lb.Etag
	}
	if lb.ID != nil {
		objectMap["id"] = lb.ID
	}
	if lb.Location != nil {
		objectMap["location"] = lb.Location
	}
	if lb.Tags != nil {
		objectMap["tags"] = lb.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoadBalancer struct.
func (lb *LoadBalancer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancerPropertiesFormat LoadBalancerPropertiesFormat
				err = json.Unmarshal(*v, &loadBalancerPropertiesFormat)
				if err != nil {
					return err
				}
				lb.LoadBalancerPropertiesFormat = &loadBalancerPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lb.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lb.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lb.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lb.Tags = tags
			}
		}
	}

	return nil
}

// LoadBalancerListResult response for ListLoadBalancers API service call.
type LoadBalancerListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of load balancers in a resource group.
	Value *[]LoadBalancer `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LoadBalancerListResultIterator provides access to a complete listing of LoadBalancer values.
type LoadBalancerListResultIterator struct {
	i    int
	page LoadBalancerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoadBalancerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoadBalancerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoadBalancerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoadBalancerListResultIterator) Response() LoadBalancerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoadBalancerListResultIterator) Value() LoadBalancer {
	if !iter.page.NotDone() {
		return LoadBalancer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoadBalancerListResultIterator type.
func NewLoadBalancerListResultIterator(page LoadBalancerListResultPage) LoadBalancerListResultIterator {
	return LoadBalancerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lblr LoadBalancerListResult) IsEmpty() bool {
	return lblr.Value == nil || len(*lblr.Value) == 0
}

// loadBalancerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lblr LoadBalancerListResult) loadBalancerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if lblr.NextLink == nil || len(to.String(lblr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lblr.NextLink)))
}

// LoadBalancerListResultPage contains a page of LoadBalancer values.
type LoadBalancerListResultPage struct {
	fn   func(context.Context, LoadBalancerListResult) (LoadBalancerListResult, error)
	lblr LoadBalancerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoadBalancerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoadBalancerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lblr)
	if err != nil {
		return err
	}
	page.lblr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoadBalancerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoadBalancerListResultPage) NotDone() bool {
	return !page.lblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoadBalancerListResultPage) Response() LoadBalancerListResult {
	return page.lblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoadBalancerListResultPage) Values() []LoadBalancer {
	if page.lblr.IsEmpty() {
		return nil
	}
	return *page.lblr.Value
}

// Creates a new instance of the LoadBalancerListResultPage type.
func NewLoadBalancerListResultPage(getNextPage func(context.Context, LoadBalancerListResult) (LoadBalancerListResult, error)) LoadBalancerListResultPage {
	return LoadBalancerListResultPage{fn: getNextPage}
}

// LoadBalancerPropertiesFormat properties of the load balancer.
type LoadBalancerPropertiesFormat struct {
	// FrontendIPConfigurations - Object representing the frontend IPs to be used for the load balancer
	FrontendIPConfigurations *[]FrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPools - Collection of backend address pools used by a load balancer
	BackendAddressPools *[]BackendAddressPool `json:"backendAddressPools,omitempty"`
	// LoadBalancingRules - Object collection representing the load balancing rules Gets the provisioning
	LoadBalancingRules *[]LoadBalancingRule `json:"loadBalancingRules,omitempty"`
	// Probes - Collection of probe objects used in the load balancer
	Probes *[]Probe `json:"probes,omitempty"`
	// InboundNatRules - Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
	InboundNatRules *[]InboundNatRule `json:"inboundNatRules,omitempty"`
	// InboundNatPools - Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
	InboundNatPools *[]InboundNatPool `json:"inboundNatPools,omitempty"`
	// OutboundNatRules - The outbound NAT rules.
	OutboundNatRules *[]OutboundNatRule `json:"outboundNatRules,omitempty"`
	// ResourceGUID - The resource GUID property of the load balancer resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LoadBalancersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LoadBalancersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LoadBalancersCreateOrUpdateFuture) Result(client LoadBalancersClient) (lb LoadBalancer, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.LoadBalancersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lb.Response.Response, err = future.GetResult(sender); err == nil && lb.Response.Response.StatusCode != http.StatusNoContent {
		lb, err = client.CreateOrUpdateResponder(lb.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.LoadBalancersCreateOrUpdateFuture", "Result", lb.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LoadBalancersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LoadBalancersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LoadBalancersDeleteFuture) Result(client LoadBalancersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LoadBalancersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.LoadBalancersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LoadBalancingRule a load balancing rule for a load balancer.
type LoadBalancingRule struct {
	*LoadBalancingRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancingRule.
func (lbr LoadBalancingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lbr.LoadBalancingRulePropertiesFormat != nil {
		objectMap["properties"] = lbr.LoadBalancingRulePropertiesFormat
	}
	if lbr.Name != nil {
		objectMap["name"] = lbr.Name
	}
	if lbr.Etag != nil {
		objectMap["etag"] = lbr.Etag
	}
	if lbr.ID != nil {
		objectMap["id"] = lbr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoadBalancingRule struct.
func (lbr *LoadBalancingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loadBalancingRulePropertiesFormat LoadBalancingRulePropertiesFormat
				err = json.Unmarshal(*v, &loadBalancingRulePropertiesFormat)
				if err != nil {
					return err
				}
				lbr.LoadBalancingRulePropertiesFormat = &loadBalancingRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lbr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lbr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lbr.ID = &ID
			}
		}
	}

	return nil
}

// LoadBalancingRulePropertiesFormat properties of the load balancer.
type LoadBalancingRulePropertiesFormat struct {
	// FrontendIPConfiguration - A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`
	// BackendAddressPool - A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// Probe - The reference of the load balancer probe used by the load balancing rule.
	Probe *SubResource `json:"probe,omitempty"`
	// Protocol - The transport protocol for the external endpoint. Possible values are 'Udp' or 'Tcp'. Possible values include: 'TransportProtocolUDP', 'TransportProtocolTCP'
	Protocol TransportProtocol `json:"protocol,omitempty"`
	// LoadDistribution - The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'. Possible values include: 'Default', 'SourceIP', 'SourceIPProtocol'
	LoadDistribution LoadDistribution `json:"loadDistribution,omitempty"`
	// FrontendPort - The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
	FrontendPort *int32 `json:"frontendPort,omitempty"`
	// BackendPort - The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// IdleTimeoutInMinutes - The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// EnableFloatingIP - Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`
	// ProvisioningState - Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LocalNetworkGateway a common class for general resource information
type LocalNetworkGateway struct {
	autorest.Response                    `json:"-"`
	*LocalNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LocalNetworkGateway.
func (lng LocalNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lng.LocalNetworkGatewayPropertiesFormat != nil {
		objectMap["properties"] = lng.LocalNetworkGatewayPropertiesFormat
	}
	if lng.Etag != nil {
		objectMap["etag"] = lng.Etag
	}
	if lng.ID != nil {
		objectMap["id"] = lng.ID
	}
	if lng.Location != nil {
		objectMap["location"] = lng.Location
	}
	if lng.Tags != nil {
		objectMap["tags"] = lng.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LocalNetworkGateway struct.
func (lng *LocalNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var localNetworkGatewayPropertiesFormat LocalNetworkGatewayPropertiesFormat
				err = json.Unmarshal(*v, &localNetworkGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				lng.LocalNetworkGatewayPropertiesFormat = &localNetworkGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lng.Tags = tags
			}
		}
	}

	return nil
}

// LocalNetworkGatewayListResult response for ListLocalNetworkGateways API service call.
type LocalNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of local network gateways that exists in a resource group.
	Value *[]LocalNetworkGateway `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LocalNetworkGatewayListResultIterator provides access to a complete listing of LocalNetworkGateway
// values.
type LocalNetworkGatewayListResultIterator struct {
	i    int
	page LocalNetworkGatewayListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LocalNetworkGatewayListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocalNetworkGatewayListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LocalNetworkGatewayListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LocalNetworkGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LocalNetworkGatewayListResultIterator) Response() LocalNetworkGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LocalNetworkGatewayListResultIterator) Value() LocalNetworkGateway {
	if !iter.page.NotDone() {
		return LocalNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LocalNetworkGatewayListResultIterator type.
func NewLocalNetworkGatewayListResultIterator(page LocalNetworkGatewayListResultPage) LocalNetworkGatewayListResultIterator {
	return LocalNetworkGatewayListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lnglr LocalNetworkGatewayListResult) IsEmpty() bool {
	return lnglr.Value == nil || len(*lnglr.Value) == 0
}

// localNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lnglr LocalNetworkGatewayListResult) localNetworkGatewayListResultPreparer(ctx context.Context) (*http.Request, error) {
	if lnglr.NextLink == nil || len(to.String(lnglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lnglr.NextLink)))
}

// LocalNetworkGatewayListResultPage contains a page of LocalNetworkGateway values.
type LocalNetworkGatewayListResultPage struct {
	fn    func(context.Context, LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)
	lnglr LocalNetworkGatewayListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LocalNetworkGatewayListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocalNetworkGatewayListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lnglr)
	if err != nil {
		return err
	}
	page.lnglr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LocalNetworkGatewayListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LocalNetworkGatewayListResultPage) NotDone() bool {
	return !page.lnglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LocalNetworkGatewayListResultPage) Response() LocalNetworkGatewayListResult {
	return page.lnglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LocalNetworkGatewayListResultPage) Values() []LocalNetworkGateway {
	if page.lnglr.IsEmpty() {
		return nil
	}
	return *page.lnglr.Value
}

// Creates a new instance of the LocalNetworkGatewayListResultPage type.
func NewLocalNetworkGatewayListResultPage(getNextPage func(context.Context, LocalNetworkGatewayListResult) (LocalNetworkGatewayListResult, error)) LocalNetworkGatewayListResultPage {
	return LocalNetworkGatewayListResultPage{fn: getNextPage}
}

// LocalNetworkGatewayPropertiesFormat localNetworkGateway properties
type LocalNetworkGatewayPropertiesFormat struct {
	// LocalNetworkAddressSpace - Local network site address space.
	LocalNetworkAddressSpace *AddressSpace `json:"localNetworkAddressSpace,omitempty"`
	// GatewayIPAddress - IP address of local network gateway.
	GatewayIPAddress *string `json:"gatewayIpAddress,omitempty"`
	// BgpSettings - Local network gateway's BGP speaker settings.
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`
	// ResourceGUID - The resource GUID property of the LocalNetworkGateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - Gets or sets Provisioning state of the LocalNetworkGateway resource Updating/Deleting/Failed
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LocalNetworkGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LocalNetworkGatewaysCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LocalNetworkGatewaysCreateOrUpdateFuture) Result(client LocalNetworkGatewaysClient) (lng LocalNetworkGateway, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.LocalNetworkGatewaysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lng.Response.Response, err = future.GetResult(sender); err == nil && lng.Response.Response.StatusCode != http.StatusNoContent {
		lng, err = client.CreateOrUpdateResponder(lng.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysCreateOrUpdateFuture", "Result", lng.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LocalNetworkGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LocalNetworkGatewaysDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LocalNetworkGatewaysDeleteFuture) Result(client LocalNetworkGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.LocalNetworkGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.LocalNetworkGatewaysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OutboundNatRule outbound NAT pool of the load balancer.
type OutboundNatRule struct {
	*OutboundNatRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundNatRule.
func (onr OutboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if onr.OutboundNatRulePropertiesFormat != nil {
		objectMap["properties"] = onr.OutboundNatRulePropertiesFormat
	}
	if onr.Name != nil {
		objectMap["name"] = onr.Name
	}
	if onr.Etag != nil {
		objectMap["etag"] = onr.Etag
	}
	if onr.ID != nil {
		objectMap["id"] = onr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OutboundNatRule struct.
func (onr *OutboundNatRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var outboundNatRulePropertiesFormat OutboundNatRulePropertiesFormat
				err = json.Unmarshal(*v, &outboundNatRulePropertiesFormat)
				if err != nil {
					return err
				}
				onr.OutboundNatRulePropertiesFormat = &outboundNatRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				onr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				onr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				onr.ID = &ID
			}
		}
	}

	return nil
}

// OutboundNatRulePropertiesFormat outbound NAT pool of the load balancer.
type OutboundNatRulePropertiesFormat struct {
	// AllocatedOutboundPorts - The number of outbound ports to be used for NAT.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`
	// FrontendIPConfigurations - The Frontend IP addresses of the load balancer.
	FrontendIPConfigurations *[]SubResource `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPool - A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`
	// ProvisioningState - Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Probe a load balancer probe.
type Probe struct {
	*ProbePropertiesFormat `json:"properties,omitempty"`
	// Name - Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Probe.
func (p Probe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProbePropertiesFormat != nil {
		objectMap["properties"] = p.ProbePropertiesFormat
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Etag != nil {
		objectMap["etag"] = p.Etag
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Probe struct.
func (p *Probe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var probePropertiesFormat ProbePropertiesFormat
				err = json.Unmarshal(*v, &probePropertiesFormat)
				if err != nil {
					return err
				}
				p.ProbePropertiesFormat = &probePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				p.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		}
	}

	return nil
}

// ProbePropertiesFormat ...
type ProbePropertiesFormat struct {
	// LoadBalancingRules - The load balancer rules that use this probe.
	LoadBalancingRules *[]SubResource `json:"loadBalancingRules,omitempty"`
	// Protocol - The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' is specified, a 200 OK response from the specifies URI is required for the probe to be successful. Possible values include: 'ProbeProtocolHTTP', 'ProbeProtocolTCP'
	Protocol ProbeProtocol `json:"protocol,omitempty"`
	// Port - The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
	Port *int32 `json:"port,omitempty"`
	// IntervalInSeconds - The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
	// NumberOfProbes - The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
	NumberOfProbes *int32 `json:"numberOfProbes,omitempty"`
	// RequestPath - The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
	RequestPath *string `json:"requestPath,omitempty"`
	// ProvisioningState - Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// PublicIPAddress public IP address resource.
type PublicIPAddress struct {
	autorest.Response                `json:"-"`
	*PublicIPAddressPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PublicIPAddress.
func (pia PublicIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pia.PublicIPAddressPropertiesFormat != nil {
		objectMap["properties"] = pia.PublicIPAddressPropertiesFormat
	}
	if pia.Etag != nil {
		objectMap["etag"] = pia.Etag
	}
	if pia.ID != nil {
		objectMap["id"] = pia.ID
	}
	if pia.Location != nil {
		objectMap["location"] = pia.Location
	}
	if pia.Tags != nil {
		objectMap["tags"] = pia.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PublicIPAddress struct.
func (pia *PublicIPAddress) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var publicIPAddressPropertiesFormat PublicIPAddressPropertiesFormat
				err = json.Unmarshal(*v, &publicIPAddressPropertiesFormat)
				if err != nil {
					return err
				}
				pia.PublicIPAddressPropertiesFormat = &publicIPAddressPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pia.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pia.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pia.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pia.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pia.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pia.Tags = tags
			}
		}
	}

	return nil
}

// PublicIPAddressDNSSettings contains FQDN of the DNS record associated with the public IP address
type PublicIPAddressDNSSettings struct {
	// DomainNameLabel - Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
	// Fqdn - Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
	Fqdn *string `json:"fqdn,omitempty"`
	// ReverseFqdn - Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
	ReverseFqdn *string `json:"reverseFqdn,omitempty"`
}

// PublicIPAddressesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PublicIPAddressesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PublicIPAddressesCreateOrUpdateFuture) Result(client PublicIPAddressesClient) (pia PublicIPAddress, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.PublicIPAddressesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pia.Response.Response, err = future.GetResult(sender); err == nil && pia.Response.Response.StatusCode != http.StatusNoContent {
		pia, err = client.CreateOrUpdateResponder(pia.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.PublicIPAddressesCreateOrUpdateFuture", "Result", pia.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PublicIPAddressesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PublicIPAddressesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PublicIPAddressesDeleteFuture) Result(client PublicIPAddressesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PublicIPAddressesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.PublicIPAddressesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PublicIPAddressListResult response for ListPublicIpAddresses API service call.
type PublicIPAddressListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of public IP addresses that exists in a resource group.
	Value *[]PublicIPAddress `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PublicIPAddressListResultIterator provides access to a complete listing of PublicIPAddress values.
type PublicIPAddressListResultIterator struct {
	i    int
	page PublicIPAddressListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublicIPAddressListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicIPAddressListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PublicIPAddressListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublicIPAddressListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PublicIPAddressListResultIterator) Response() PublicIPAddressListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublicIPAddressListResultIterator) Value() PublicIPAddress {
	if !iter.page.NotDone() {
		return PublicIPAddress{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PublicIPAddressListResultIterator type.
func NewPublicIPAddressListResultIterator(page PublicIPAddressListResultPage) PublicIPAddressListResultIterator {
	return PublicIPAddressListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pialr PublicIPAddressListResult) IsEmpty() bool {
	return pialr.Value == nil || len(*pialr.Value) == 0
}

// publicIPAddressListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pialr PublicIPAddressListResult) publicIPAddressListResultPreparer(ctx context.Context) (*http.Request, error) {
	if pialr.NextLink == nil || len(to.String(pialr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pialr.NextLink)))
}

// PublicIPAddressListResultPage contains a page of PublicIPAddress values.
type PublicIPAddressListResultPage struct {
	fn    func(context.Context, PublicIPAddressListResult) (PublicIPAddressListResult, error)
	pialr PublicIPAddressListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublicIPAddressListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicIPAddressListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pialr)
	if err != nil {
		return err
	}
	page.pialr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PublicIPAddressListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublicIPAddressListResultPage) NotDone() bool {
	return !page.pialr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PublicIPAddressListResultPage) Response() PublicIPAddressListResult {
	return page.pialr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PublicIPAddressListResultPage) Values() []PublicIPAddress {
	if page.pialr.IsEmpty() {
		return nil
	}
	return *page.pialr.Value
}

// Creates a new instance of the PublicIPAddressListResultPage type.
func NewPublicIPAddressListResultPage(getNextPage func(context.Context, PublicIPAddressListResult) (PublicIPAddressListResult, error)) PublicIPAddressListResultPage {
	return PublicIPAddressListResultPage{fn: getNextPage}
}

// PublicIPAddressPropertiesFormat public IP address properties.
type PublicIPAddressPropertiesFormat struct {
	// PublicIPAllocationMethod - The public IP allocation method. Possible values are: 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PublicIPAllocationMethod IPAllocationMethod `json:"publicIPAllocationMethod,omitempty"`
	IPConfiguration          *IPConfiguration   `json:"ipConfiguration,omitempty"`
	// DNSSettings - The FQDN of the DNS record associated with the public IP address.
	DNSSettings *PublicIPAddressDNSSettings `json:"dnsSettings,omitempty"`
	IPAddress   *string                     `json:"ipAddress,omitempty"`
	// IdleTimeoutInMinutes - The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`
	// ResourceGUID - The resource GUID property of the public IP resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Resource azure resource manager resource properties.
type Resource struct {
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// Route route resource
type Route struct {
	autorest.Response      `json:"-"`
	*RoutePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Route.
func (r Route) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RoutePropertiesFormat != nil {
		objectMap["properties"] = r.RoutePropertiesFormat
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Route struct.
func (r *Route) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routePropertiesFormat RoutePropertiesFormat
				err = json.Unmarshal(*v, &routePropertiesFormat)
				if err != nil {
					return err
				}
				r.RoutePropertiesFormat = &routePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				r.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		}
	}

	return nil
}

// RouteListResult response for the ListRoute API service call
type RouteListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of routes in a resource group.
	Value *[]Route `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteListResultIterator provides access to a complete listing of Route values.
type RouteListResultIterator struct {
	i    int
	page RouteListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RouteListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteListResultIterator) Response() RouteListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteListResultIterator) Value() Route {
	if !iter.page.NotDone() {
		return Route{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RouteListResultIterator type.
func NewRouteListResultIterator(page RouteListResultPage) RouteListResultIterator {
	return RouteListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RouteListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// routeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RouteListResult) routeListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rlr.NextLink == nil || len(to.String(rlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RouteListResultPage contains a page of Route values.
type RouteListResultPage struct {
	fn  func(context.Context, RouteListResult) (RouteListResult, error)
	rlr RouteListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rlr)
	if err != nil {
		return err
	}
	page.rlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RouteListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteListResultPage) Response() RouteListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteListResultPage) Values() []Route {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RouteListResultPage type.
func NewRouteListResultPage(getNextPage func(context.Context, RouteListResult) (RouteListResult, error)) RouteListResultPage {
	return RouteListResultPage{fn: getNextPage}
}

// RoutePropertiesFormat route resource
type RoutePropertiesFormat struct {
	// AddressPrefix - The destination CIDR to which the route applies.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NextHopType - The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Possible values include: 'RouteNextHopTypeVirtualNetworkGateway', 'RouteNextHopTypeVnetLocal', 'RouteNextHopTypeInternet', 'RouteNextHopTypeVirtualAppliance', 'RouteNextHopTypeNone'
	NextHopType RouteNextHopType `json:"nextHopType,omitempty"`
	// NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`
	// ProvisioningState - The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// RoutesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RoutesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RoutesCreateOrUpdateFuture) Result(client RoutesClient) (r Route, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.RoutesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateOrUpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RoutesCreateOrUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RoutesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RoutesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RoutesDeleteFuture) Result(client RoutesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RoutesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.RoutesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RouteTable route table resource.
type RouteTable struct {
	autorest.Response           `json:"-"`
	*RouteTablePropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for RouteTable.
func (rt RouteTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.RouteTablePropertiesFormat != nil {
		objectMap["properties"] = rt.RouteTablePropertiesFormat
	}
	if rt.Etag != nil {
		objectMap["etag"] = rt.Etag
	}
	if rt.ID != nil {
		objectMap["id"] = rt.ID
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RouteTable struct.
func (rt *RouteTable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var routeTablePropertiesFormat RouteTablePropertiesFormat
				err = json.Unmarshal(*v, &routeTablePropertiesFormat)
				if err != nil {
					return err
				}
				rt.RouteTablePropertiesFormat = &routeTablePropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rt.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = tags
			}
		}
	}

	return nil
}

// RouteTableListResult response for the ListRouteTable API service call.
type RouteTableListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of route tables in a resource group.
	Value *[]RouteTable `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RouteTableListResultIterator provides access to a complete listing of RouteTable values.
type RouteTableListResultIterator struct {
	i    int
	page RouteTableListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RouteTableListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteTableListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RouteTableListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RouteTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RouteTableListResultIterator) Response() RouteTableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RouteTableListResultIterator) Value() RouteTable {
	if !iter.page.NotDone() {
		return RouteTable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RouteTableListResultIterator type.
func NewRouteTableListResultIterator(page RouteTableListResultPage) RouteTableListResultIterator {
	return RouteTableListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rtlr RouteTableListResult) IsEmpty() bool {
	return rtlr.Value == nil || len(*rtlr.Value) == 0
}

// routeTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rtlr RouteTableListResult) routeTableListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rtlr.NextLink == nil || len(to.String(rtlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rtlr.NextLink)))
}

// RouteTableListResultPage contains a page of RouteTable values.
type RouteTableListResultPage struct {
	fn   func(context.Context, RouteTableListResult) (RouteTableListResult, error)
	rtlr RouteTableListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RouteTableListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RouteTableListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rtlr)
	if err != nil {
		return err
	}
	page.rtlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RouteTableListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RouteTableListResultPage) NotDone() bool {
	return !page.rtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RouteTableListResultPage) Response() RouteTableListResult {
	return page.rtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RouteTableListResultPage) Values() []RouteTable {
	if page.rtlr.IsEmpty() {
		return nil
	}
	return *page.rtlr.Value
}

// Creates a new instance of the RouteTableListResultPage type.
func NewRouteTableListResultPage(getNextPage func(context.Context, RouteTableListResult) (RouteTableListResult, error)) RouteTableListResultPage {
	return RouteTableListResultPage{fn: getNextPage}
}

// RouteTablePropertiesFormat route Table resource
type RouteTablePropertiesFormat struct {
	// Routes - Collection of routes contained within a route table.
	Routes *[]Route `json:"routes,omitempty"`
	// Subnets - A collection of references to subnets.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// ProvisioningState - The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// RouteTablesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RouteTablesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RouteTablesCreateOrUpdateFuture) Result(client RouteTablesClient) (rt RouteTable, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.RouteTablesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rt.Response.Response, err = future.GetResult(sender); err == nil && rt.Response.Response.StatusCode != http.StatusNoContent {
		rt, err = client.CreateOrUpdateResponder(rt.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.RouteTablesCreateOrUpdateFuture", "Result", rt.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RouteTablesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RouteTablesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RouteTablesDeleteFuture) Result(client RouteTablesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.RouteTablesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.RouteTablesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SecurityGroup networkSecurityGroup resource.
type SecurityGroup struct {
	autorest.Response              `json:"-"`
	*SecurityGroupPropertiesFormat `json:"properties,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SecurityGroup.
func (sg SecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sg.SecurityGroupPropertiesFormat != nil {
		objectMap["properties"] = sg.SecurityGroupPropertiesFormat
	}
	if sg.Etag != nil {
		objectMap["etag"] = sg.Etag
	}
	if sg.ID != nil {
		objectMap["id"] = sg.ID
	}
	if sg.Location != nil {
		objectMap["location"] = sg.Location
	}
	if sg.Tags != nil {
		objectMap["tags"] = sg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityGroup struct.
func (sg *SecurityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityGroupPropertiesFormat SecurityGroupPropertiesFormat
				err = json.Unmarshal(*v, &securityGroupPropertiesFormat)
				if err != nil {
					return err
				}
				sg.SecurityGroupPropertiesFormat = &securityGroupPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sg.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sg.Tags = tags
			}
		}
	}

	return nil
}

// SecurityGroupListResult response for ListNetworkSecurityGroups API service call.
type SecurityGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of NetworkSecurityGroup resources.
	Value *[]SecurityGroup `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecurityGroupListResultIterator provides access to a complete listing of SecurityGroup values.
type SecurityGroupListResultIterator struct {
	i    int
	page SecurityGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecurityGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecurityGroupListResultIterator) Response() SecurityGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityGroupListResultIterator) Value() SecurityGroup {
	if !iter.page.NotDone() {
		return SecurityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecurityGroupListResultIterator type.
func NewSecurityGroupListResultIterator(page SecurityGroupListResultPage) SecurityGroupListResultIterator {
	return SecurityGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sglr SecurityGroupListResult) IsEmpty() bool {
	return sglr.Value == nil || len(*sglr.Value) == 0
}

// securityGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sglr SecurityGroupListResult) securityGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sglr.NextLink == nil || len(to.String(sglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sglr.NextLink)))
}

// SecurityGroupListResultPage contains a page of SecurityGroup values.
type SecurityGroupListResultPage struct {
	fn   func(context.Context, SecurityGroupListResult) (SecurityGroupListResult, error)
	sglr SecurityGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sglr)
	if err != nil {
		return err
	}
	page.sglr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecurityGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityGroupListResultPage) NotDone() bool {
	return !page.sglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecurityGroupListResultPage) Response() SecurityGroupListResult {
	return page.sglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityGroupListResultPage) Values() []SecurityGroup {
	if page.sglr.IsEmpty() {
		return nil
	}
	return *page.sglr.Value
}

// Creates a new instance of the SecurityGroupListResultPage type.
func NewSecurityGroupListResultPage(getNextPage func(context.Context, SecurityGroupListResult) (SecurityGroupListResult, error)) SecurityGroupListResultPage {
	return SecurityGroupListResultPage{fn: getNextPage}
}

// SecurityGroupPropertiesFormat network Security Group resource.
type SecurityGroupPropertiesFormat struct {
	// SecurityRules - A collection of security rules of the network security group.
	SecurityRules *[]SecurityRule `json:"securityRules,omitempty"`
	// DefaultSecurityRules - The default security rules of network security group.
	DefaultSecurityRules *[]SecurityRule `json:"defaultSecurityRules,omitempty"`
	// NetworkInterfaces - A collection of references to network interfaces.
	NetworkInterfaces *[]Interface `json:"networkInterfaces,omitempty"`
	// Subnets - A collection of references to subnets.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// ResourceGUID - The resource GUID property of the network security group resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// SecurityGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SecurityGroupsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SecurityGroupsCreateOrUpdateFuture) Result(client SecurityGroupsClient) (sg SecurityGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.SecurityGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sg.Response.Response, err = future.GetResult(sender); err == nil && sg.Response.Response.StatusCode != http.StatusNoContent {
		sg, err = client.CreateOrUpdateResponder(sg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SecurityGroupsCreateOrUpdateFuture", "Result", sg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SecurityGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityGroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SecurityGroupsDeleteFuture) Result(client SecurityGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.SecurityGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SecurityRule network security rule.
type SecurityRule struct {
	autorest.Response             `json:"-"`
	*SecurityRulePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityRule.
func (sr SecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.SecurityRulePropertiesFormat != nil {
		objectMap["properties"] = sr.SecurityRulePropertiesFormat
	}
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Etag != nil {
		objectMap["etag"] = sr.Etag
	}
	if sr.ID != nil {
		objectMap["id"] = sr.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecurityRule struct.
func (sr *SecurityRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityRulePropertiesFormat SecurityRulePropertiesFormat
				err = json.Unmarshal(*v, &securityRulePropertiesFormat)
				if err != nil {
					return err
				}
				sr.SecurityRulePropertiesFormat = &securityRulePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		}
	}

	return nil
}

// SecurityRuleListResult response for ListSecurityRule API service call. Retrieves all security rules that
// belongs to a network security group.
type SecurityRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The security rules in a network security group.
	Value *[]SecurityRule `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecurityRuleListResultIterator provides access to a complete listing of SecurityRule values.
type SecurityRuleListResultIterator struct {
	i    int
	page SecurityRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecurityRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecurityRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecurityRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecurityRuleListResultIterator) Response() SecurityRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecurityRuleListResultIterator) Value() SecurityRule {
	if !iter.page.NotDone() {
		return SecurityRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecurityRuleListResultIterator type.
func NewSecurityRuleListResultIterator(page SecurityRuleListResultPage) SecurityRuleListResultIterator {
	return SecurityRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srlr SecurityRuleListResult) IsEmpty() bool {
	return srlr.Value == nil || len(*srlr.Value) == 0
}

// securityRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srlr SecurityRuleListResult) securityRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if srlr.NextLink == nil || len(to.String(srlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srlr.NextLink)))
}

// SecurityRuleListResultPage contains a page of SecurityRule values.
type SecurityRuleListResultPage struct {
	fn   func(context.Context, SecurityRuleListResult) (SecurityRuleListResult, error)
	srlr SecurityRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecurityRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecurityRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.srlr)
	if err != nil {
		return err
	}
	page.srlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecurityRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecurityRuleListResultPage) NotDone() bool {
	return !page.srlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecurityRuleListResultPage) Response() SecurityRuleListResult {
	return page.srlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecurityRuleListResultPage) Values() []SecurityRule {
	if page.srlr.IsEmpty() {
		return nil
	}
	return *page.srlr.Value
}

// Creates a new instance of the SecurityRuleListResultPage type.
func NewSecurityRuleListResultPage(getNextPage func(context.Context, SecurityRuleListResult) (SecurityRuleListResult, error)) SecurityRuleListResultPage {
	return SecurityRuleListResultPage{fn: getNextPage}
}

// SecurityRulePropertiesFormat ...
type SecurityRulePropertiesFormat struct {
	// Description - A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`
	// Protocol - Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'. Possible values include: 'TCP', 'UDP', 'Asterisk'
	Protocol SecurityRuleProtocol `json:"protocol,omitempty"`
	// SourcePortRange - The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
	// DestinationPortRange - The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`
	// SourceAddressPrefix - The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// DestinationAddressPrefix - The destination address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`
	// Access - The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'. Possible values include: 'Allow', 'Deny'
	Access SecurityRuleAccess `json:"access,omitempty"`
	// Priority - The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Direction - The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'. Possible values include: 'Inbound', 'Outbound'
	Direction SecurityRuleDirection `json:"direction,omitempty"`
	// ProvisioningState - The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// SecurityRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SecurityRulesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SecurityRulesCreateOrUpdateFuture) Result(client SecurityRulesClient) (sr SecurityRule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.SecurityRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.CreateOrUpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SecurityRulesCreateOrUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SecurityRulesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SecurityRulesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SecurityRulesDeleteFuture) Result(client SecurityRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SecurityRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.SecurityRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// Subnet subnet in a virtual network resource.
type Subnet struct {
	autorest.Response       `json:"-"`
	*SubnetPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Subnet.
func (s Subnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SubnetPropertiesFormat != nil {
		objectMap["properties"] = s.SubnetPropertiesFormat
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Subnet struct.
func (s *Subnet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subnetPropertiesFormat SubnetPropertiesFormat
				err = json.Unmarshal(*v, &subnetPropertiesFormat)
				if err != nil {
					return err
				}
				s.SubnetPropertiesFormat = &subnetPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				s.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		}
	}

	return nil
}

// SubnetListResult response for ListSubnets API service callRetrieves all subnet that belongs to a virtual
// network
type SubnetListResult struct {
	autorest.Response `json:"-"`
	// Value - The subnets in a virtual network.
	Value *[]Subnet `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubnetListResultIterator provides access to a complete listing of Subnet values.
type SubnetListResultIterator struct {
	i    int
	page SubnetListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubnetListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubnetListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubnetListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubnetListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubnetListResultIterator) Response() SubnetListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubnetListResultIterator) Value() Subnet {
	if !iter.page.NotDone() {
		return Subnet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubnetListResultIterator type.
func NewSubnetListResultIterator(page SubnetListResultPage) SubnetListResultIterator {
	return SubnetListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SubnetListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// subnetListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SubnetListResult) subnetListResultPreparer(ctx context.Context) (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SubnetListResultPage contains a page of Subnet values.
type SubnetListResultPage struct {
	fn  func(context.Context, SubnetListResult) (SubnetListResult, error)
	slr SubnetListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubnetListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubnetListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubnetListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubnetListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubnetListResultPage) Response() SubnetListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubnetListResultPage) Values() []Subnet {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SubnetListResultPage type.
func NewSubnetListResultPage(getNextPage func(context.Context, SubnetListResult) (SubnetListResult, error)) SubnetListResultPage {
	return SubnetListResultPage{fn: getNextPage}
}

// SubnetPropertiesFormat ...
type SubnetPropertiesFormat struct {
	// AddressPrefix - The address prefix for the subnet.
	AddressPrefix *string `json:"addressPrefix,omitempty"`
	// NetworkSecurityGroup - The reference of the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`
	// RouteTable - The reference of the RouteTable resource.
	RouteTable *RouteTable `json:"routeTable,omitempty"`
	// IPConfigurations - Gets an array of references to the network interface IP configurations using subnet.
	IPConfigurations *[]IPConfiguration `json:"ipConfigurations,omitempty"`
	// ProvisioningState - The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// SubnetsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubnetsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SubnetsCreateOrUpdateFuture) Result(client SubnetsClient) (s Subnet, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.SubnetsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.SubnetsCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SubnetsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubnetsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SubnetsDeleteFuture) Result(client SubnetsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.SubnetsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.SubnetsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SubResource azure resource manager sub resource properties.
type SubResource struct {
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// Usage describes network resource usage.
type Usage struct {
	// Unit - An enum describing the unit of measurement.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The limit of usage.
	Limit *int64 `json:"limit,omitempty"`
	// Name - The name of the type of usage.
	Name *UsageName `json:"name,omitempty"`
}

// UsageName the usage names.
type UsageName struct {
	// Value - A string describing the resource name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - A localized string describing the resource name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsagesListResult the list usages operation response.
type UsagesListResult struct {
	autorest.Response `json:"-"`
	// Value - The list network resource usages.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UsagesListResultIterator provides access to a complete listing of Usage values.
type UsagesListResultIterator struct {
	i    int
	page UsagesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsagesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsagesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsagesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsagesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsagesListResultIterator) Response() UsagesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsagesListResultIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsagesListResultIterator type.
func NewUsagesListResultIterator(page UsagesListResultPage) UsagesListResultIterator {
	return UsagesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ulr UsagesListResult) IsEmpty() bool {
	return ulr.Value == nil || len(*ulr.Value) == 0
}

// usagesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ulr UsagesListResult) usagesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ulr.NextLink == nil || len(to.String(ulr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ulr.NextLink)))
}

// UsagesListResultPage contains a page of Usage values.
type UsagesListResultPage struct {
	fn  func(context.Context, UsagesListResult) (UsagesListResult, error)
	ulr UsagesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsagesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsagesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ulr)
	if err != nil {
		return err
	}
	page.ulr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsagesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsagesListResultPage) NotDone() bool {
	return !page.ulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsagesListResultPage) Response() UsagesListResult {
	return page.ulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsagesListResultPage) Values() []Usage {
	if page.ulr.IsEmpty() {
		return nil
	}
	return *page.ulr.Value
}

// Creates a new instance of the UsagesListResultPage type.
func NewUsagesListResultPage(getNextPage func(context.Context, UsagesListResult) (UsagesListResult, error)) UsagesListResultPage {
	return UsagesListResultPage{fn: getNextPage}
}

// VirtualNetwork virtual Network resource.
type VirtualNetwork struct {
	autorest.Response               `json:"-"`
	*VirtualNetworkPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetwork.
func (vn VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vn.VirtualNetworkPropertiesFormat != nil {
		objectMap["properties"] = vn.VirtualNetworkPropertiesFormat
	}
	if vn.Etag != nil {
		objectMap["etag"] = vn.Etag
	}
	if vn.ID != nil {
		objectMap["id"] = vn.ID
	}
	if vn.Location != nil {
		objectMap["location"] = vn.Location
	}
	if vn.Tags != nil {
		objectMap["tags"] = vn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetwork struct.
func (vn *VirtualNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkPropertiesFormat VirtualNetworkPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkPropertiesFormat)
				if err != nil {
					return err
				}
				vn.VirtualNetworkPropertiesFormat = &virtualNetworkPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vn.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vn.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vn.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGateway a common class for general resource information
type VirtualNetworkGateway struct {
	autorest.Response                      `json:"-"`
	*VirtualNetworkGatewayPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGateway.
func (vng VirtualNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vng.VirtualNetworkGatewayPropertiesFormat != nil {
		objectMap["properties"] = vng.VirtualNetworkGatewayPropertiesFormat
	}
	if vng.Etag != nil {
		objectMap["etag"] = vng.Etag
	}
	if vng.ID != nil {
		objectMap["id"] = vng.ID
	}
	if vng.Location != nil {
		objectMap["location"] = vng.Location
	}
	if vng.Tags != nil {
		objectMap["tags"] = vng.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGateway struct.
func (vng *VirtualNetworkGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayPropertiesFormat VirtualNetworkGatewayPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayPropertiesFormat)
				if err != nil {
					return err
				}
				vng.VirtualNetworkGatewayPropertiesFormat = &virtualNetworkGatewayPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vng.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vng.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vng.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vng.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vng.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vng.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayConnection a common class for general resource information
type VirtualNetworkGatewayConnection struct {
	autorest.Response                                `json:"-"`
	*VirtualNetworkGatewayConnectionPropertiesFormat `json:"properties,omitempty"`
	// Etag - Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGatewayConnection.
func (vngc VirtualNetworkGatewayConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngc.VirtualNetworkGatewayConnectionPropertiesFormat != nil {
		objectMap["properties"] = vngc.VirtualNetworkGatewayConnectionPropertiesFormat
	}
	if vngc.Etag != nil {
		objectMap["etag"] = vngc.Etag
	}
	if vngc.ID != nil {
		objectMap["id"] = vngc.ID
	}
	if vngc.Location != nil {
		objectMap["location"] = vngc.Location
	}
	if vngc.Tags != nil {
		objectMap["tags"] = vngc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGatewayConnection struct.
func (vngc *VirtualNetworkGatewayConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayConnectionPropertiesFormat VirtualNetworkGatewayConnectionPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayConnectionPropertiesFormat)
				if err != nil {
					return err
				}
				vngc.VirtualNetworkGatewayConnectionPropertiesFormat = &virtualNetworkGatewayConnectionPropertiesFormat
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vngc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vngc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vngc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vngc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vngc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vngc.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayConnectionListResult response for the ListVirtualNetworkGatewayConnections API
// service call
type VirtualNetworkGatewayConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of VirtualNetworkGatewayConnection resources that exists in a resource group.
	Value *[]VirtualNetworkGatewayConnection `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayConnectionListResultIterator provides access to a complete listing of
// VirtualNetworkGatewayConnection values.
type VirtualNetworkGatewayConnectionListResultIterator struct {
	i    int
	page VirtualNetworkGatewayConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkGatewayConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkGatewayConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkGatewayConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkGatewayConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkGatewayConnectionListResultIterator) Response() VirtualNetworkGatewayConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkGatewayConnectionListResultIterator) Value() VirtualNetworkGatewayConnection {
	if !iter.page.NotDone() {
		return VirtualNetworkGatewayConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkGatewayConnectionListResultIterator type.
func NewVirtualNetworkGatewayConnectionListResultIterator(page VirtualNetworkGatewayConnectionListResultPage) VirtualNetworkGatewayConnectionListResultIterator {
	return VirtualNetworkGatewayConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vngclr VirtualNetworkGatewayConnectionListResult) IsEmpty() bool {
	return vngclr.Value == nil || len(*vngclr.Value) == 0
}

// virtualNetworkGatewayConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vngclr VirtualNetworkGatewayConnectionListResult) virtualNetworkGatewayConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if vngclr.NextLink == nil || len(to.String(vngclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vngclr.NextLink)))
}

// VirtualNetworkGatewayConnectionListResultPage contains a page of VirtualNetworkGatewayConnection values.
type VirtualNetworkGatewayConnectionListResultPage struct {
	fn     func(context.Context, VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)
	vngclr VirtualNetworkGatewayConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkGatewayConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkGatewayConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.vngclr)
	if err != nil {
		return err
	}
	page.vngclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkGatewayConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkGatewayConnectionListResultPage) NotDone() bool {
	return !page.vngclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkGatewayConnectionListResultPage) Response() VirtualNetworkGatewayConnectionListResult {
	return page.vngclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkGatewayConnectionListResultPage) Values() []VirtualNetworkGatewayConnection {
	if page.vngclr.IsEmpty() {
		return nil
	}
	return *page.vngclr.Value
}

// Creates a new instance of the VirtualNetworkGatewayConnectionListResultPage type.
func NewVirtualNetworkGatewayConnectionListResultPage(getNextPage func(context.Context, VirtualNetworkGatewayConnectionListResult) (VirtualNetworkGatewayConnectionListResult, error)) VirtualNetworkGatewayConnectionListResultPage {
	return VirtualNetworkGatewayConnectionListResultPage{fn: getNextPage}
}

// VirtualNetworkGatewayConnectionPropertiesFormat virtualNetworkGatewayConnection properties
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	// AuthorizationKey - The authorizationKey.
	AuthorizationKey       *string                `json:"authorizationKey,omitempty"`
	VirtualNetworkGateway1 *VirtualNetworkGateway `json:"virtualNetworkGateway1,omitempty"`
	VirtualNetworkGateway2 *VirtualNetworkGateway `json:"virtualNetworkGateway2,omitempty"`
	LocalNetworkGateway2   *LocalNetworkGateway   `json:"localNetworkGateway2,omitempty"`
	// ConnectionType - Gateway connection type. Possible values are: 'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Possible values include: 'IPsec', 'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
	ConnectionType VirtualNetworkGatewayConnectionType `json:"connectionType,omitempty"`
	// RoutingWeight - The routing weight.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`
	// SharedKey - The IPSec shared key.
	SharedKey *string `json:"sharedKey,omitempty"`
	// ConnectionStatus - Virtual network Gateway connection status. Possible values are 'Unknown', 'Connecting', 'Connected' and 'NotConnected'. Possible values include: 'Unknown', 'Connecting', 'Connected', 'NotConnected'
	ConnectionStatus VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty"`
	// EgressBytesTransferred - The egress bytes transferred in this connection.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty"`
	// IngressBytesTransferred - The ingress bytes transferred in this connection.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty"`
	// Peer - The reference to peerings resource.
	Peer *SubResource `json:"peer,omitempty"`
	// EnableBgp - EnableBgp flag
	EnableBgp *bool `json:"enableBgp,omitempty"`
	// ResourceGUID - The resource GUID property of the VirtualNetworkGatewayConnection resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the VirtualNetworkGatewayConnection resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualNetworkGatewayConnectionsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkGatewayConnectionsCreateOrUpdateFuture) Result(client VirtualNetworkGatewayConnectionsClient) (vngc VirtualNetworkGatewayConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vngc.Response.Response, err = future.GetResult(sender); err == nil && vngc.Response.Response.StatusCode != http.StatusNoContent {
		vngc, err = client.CreateOrUpdateResponder(vngc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsCreateOrUpdateFuture", "Result", vngc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkGatewayConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type VirtualNetworkGatewayConnectionsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkGatewayConnectionsDeleteFuture) Result(client VirtualNetworkGatewayConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualNetworkGatewayConnectionsResetSharedKeyFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualNetworkGatewayConnectionsResetSharedKeyFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkGatewayConnectionsResetSharedKeyFuture) Result(client VirtualNetworkGatewayConnectionsClient) (crsk ConnectionResetSharedKey, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if crsk.Response.Response, err = future.GetResult(sender); err == nil && crsk.Response.Response.StatusCode != http.StatusNoContent {
		crsk, err = client.ResetSharedKeyResponder(crsk.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsResetSharedKeyFuture", "Result", crsk.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkGatewayConnectionsSetSharedKeyFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualNetworkGatewayConnectionsSetSharedKeyFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkGatewayConnectionsSetSharedKeyFuture) Result(client VirtualNetworkGatewayConnectionsClient) (csk ConnectionSharedKey, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if csk.Response.Response, err = future.GetResult(sender); err == nil && csk.Response.Response.StatusCode != http.StatusNoContent {
		csk, err = client.SetSharedKeyResponder(csk.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewayConnectionsSetSharedKeyFuture", "Result", csk.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkGatewayIPConfiguration IP configuration for virtual network gateway
type VirtualNetworkGatewayIPConfiguration struct {
	*VirtualNetworkGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkGatewayIPConfiguration.
func (vngic VirtualNetworkGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat != nil {
		objectMap["properties"] = vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat
	}
	if vngic.Name != nil {
		objectMap["name"] = vngic.Name
	}
	if vngic.Etag != nil {
		objectMap["etag"] = vngic.Etag
	}
	if vngic.ID != nil {
		objectMap["id"] = vngic.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkGatewayIPConfiguration struct.
func (vngic *VirtualNetworkGatewayIPConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkGatewayIPConfigurationPropertiesFormat VirtualNetworkGatewayIPConfigurationPropertiesFormat
				err = json.Unmarshal(*v, &virtualNetworkGatewayIPConfigurationPropertiesFormat)
				if err != nil {
					return err
				}
				vngic.VirtualNetworkGatewayIPConfigurationPropertiesFormat = &virtualNetworkGatewayIPConfigurationPropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vngic.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vngic.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vngic.ID = &ID
			}
		}
	}

	return nil
}

// VirtualNetworkGatewayIPConfigurationPropertiesFormat properties of VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat struct {
	// PrivateIPAddress - Gets or sets the privateIPAddress of the IP Configuration
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`
	// PrivateIPAllocationMethod - The private IP allocation method. Possible values are: 'Static' and 'Dynamic'. Possible values include: 'Static', 'Dynamic'
	PrivateIPAllocationMethod IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`
	// Subnet - The reference of the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`
	// PublicIPAddress - The reference of the public IP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`
	// ProvisioningState - The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewayListResult response for the ListVirtualNetworkGateways API service call.
type VirtualNetworkGatewayListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of VirtualNetworkGateway resources that exists in a resource group.
	Value *[]VirtualNetworkGateway `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkGatewayListResultIterator provides access to a complete listing of VirtualNetworkGateway
// values.
type VirtualNetworkGatewayListResultIterator struct {
	i    int
	page VirtualNetworkGatewayListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkGatewayListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkGatewayListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkGatewayListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkGatewayListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkGatewayListResultIterator) Response() VirtualNetworkGatewayListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkGatewayListResultIterator) Value() VirtualNetworkGateway {
	if !iter.page.NotDone() {
		return VirtualNetworkGateway{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkGatewayListResultIterator type.
func NewVirtualNetworkGatewayListResultIterator(page VirtualNetworkGatewayListResultPage) VirtualNetworkGatewayListResultIterator {
	return VirtualNetworkGatewayListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnglr VirtualNetworkGatewayListResult) IsEmpty() bool {
	return vnglr.Value == nil || len(*vnglr.Value) == 0
}

// virtualNetworkGatewayListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnglr VirtualNetworkGatewayListResult) virtualNetworkGatewayListResultPreparer(ctx context.Context) (*http.Request, error) {
	if vnglr.NextLink == nil || len(to.String(vnglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnglr.NextLink)))
}

// VirtualNetworkGatewayListResultPage contains a page of VirtualNetworkGateway values.
type VirtualNetworkGatewayListResultPage struct {
	fn    func(context.Context, VirtualNetworkGatewayListResult) (VirtualNetworkGatewayListResult, error)
	vnglr VirtualNetworkGatewayListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkGatewayListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkGatewayListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.vnglr)
	if err != nil {
		return err
	}
	page.vnglr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkGatewayListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkGatewayListResultPage) NotDone() bool {
	return !page.vnglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkGatewayListResultPage) Response() VirtualNetworkGatewayListResult {
	return page.vnglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkGatewayListResultPage) Values() []VirtualNetworkGateway {
	if page.vnglr.IsEmpty() {
		return nil
	}
	return *page.vnglr.Value
}

// Creates a new instance of the VirtualNetworkGatewayListResultPage type.
func NewVirtualNetworkGatewayListResultPage(getNextPage func(context.Context, VirtualNetworkGatewayListResult) (VirtualNetworkGatewayListResult, error)) VirtualNetworkGatewayListResultPage {
	return VirtualNetworkGatewayListResultPage{fn: getNextPage}
}

// VirtualNetworkGatewayPropertiesFormat virtualNetworkGateway properties
type VirtualNetworkGatewayPropertiesFormat struct {
	// IPConfigurations - IP configurations for virtual network gateway.
	IPConfigurations *[]VirtualNetworkGatewayIPConfiguration `json:"ipConfigurations,omitempty"`
	// GatewayType - The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'. Possible values include: 'VirtualNetworkGatewayTypeVpn', 'VirtualNetworkGatewayTypeExpressRoute'
	GatewayType VirtualNetworkGatewayType `json:"gatewayType,omitempty"`
	// VpnType - The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'. Possible values include: 'PolicyBased', 'RouteBased'
	VpnType VpnType `json:"vpnType,omitempty"`
	// EnableBgp - Whether BGP is enabled for this virtual network gateway or not.
	EnableBgp *bool `json:"enableBgp,omitempty"`
	// GatewayDefaultSite - The reference of the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
	GatewayDefaultSite *SubResource `json:"gatewayDefaultSite,omitempty"`
	// Sku - The reference of the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
	Sku *VirtualNetworkGatewaySku `json:"sku,omitempty"`
	// VpnClientConfiguration - The reference of the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
	VpnClientConfiguration *VpnClientConfiguration `json:"vpnClientConfiguration,omitempty"`
	// BgpSettings - Virtual network gateway's BGP speaker settings.
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`
	// ResourceGUID - The resource GUID property of the VirtualNetworkGateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the VirtualNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworkGatewaysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkGatewaysCreateOrUpdateFuture) Result(client VirtualNetworkGatewaysClient) (vng VirtualNetworkGateway, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vng.Response.Response, err = future.GetResult(sender); err == nil && vng.Response.Response.StatusCode != http.StatusNoContent {
		vng, err = client.CreateOrUpdateResponder(vng.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysCreateOrUpdateFuture", "Result", vng.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkGatewaysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkGatewaysDeleteFuture) Result(client VirtualNetworkGatewaysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualNetworkGatewaysGeneratevpnclientpackageFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type VirtualNetworkGatewaysGeneratevpnclientpackageFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkGatewaysGeneratevpnclientpackageFuture) Result(client VirtualNetworkGatewaysClient) (s String, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGeneratevpnclientpackageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysGeneratevpnclientpackageFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.GeneratevpnclientpackageResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysGeneratevpnclientpackageFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkGatewaySku virtualNetworkGatewaySku details
type VirtualNetworkGatewaySku struct {
	// Name - Gateway sku name -Basic/HighPerformance/Standard. Possible values include: 'VirtualNetworkGatewaySkuNameBasic', 'VirtualNetworkGatewaySkuNameHighPerformance', 'VirtualNetworkGatewaySkuNameStandard'
	Name VirtualNetworkGatewaySkuName `json:"name,omitempty"`
	// Tier - Gateway sku tier -Basic/HighPerformance/Standard. Possible values include: 'VirtualNetworkGatewaySkuTierBasic', 'VirtualNetworkGatewaySkuTierHighPerformance', 'VirtualNetworkGatewaySkuTierStandard'
	Tier VirtualNetworkGatewaySkuTier `json:"tier,omitempty"`
	// Capacity - The capacity
	Capacity *int32 `json:"capacity,omitempty"`
}

// VirtualNetworkGatewaysResetFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkGatewaysResetFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkGatewaysResetFuture) Result(client VirtualNetworkGatewaysClient) (vng VirtualNetworkGateway, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysResetFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.VirtualNetworkGatewaysResetFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vng.Response.Response, err = future.GetResult(sender); err == nil && vng.Response.Response.StatusCode != http.StatusNoContent {
		vng, err = client.ResetResponder(vng.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworkGatewaysResetFuture", "Result", vng.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkListResult response for the ListVirtualNetworks API service call.
type VirtualNetworkListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets a list of VirtualNetwork resources in a resource group.
	Value *[]VirtualNetwork `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkListResultIterator provides access to a complete listing of VirtualNetwork values.
type VirtualNetworkListResultIterator struct {
	i    int
	page VirtualNetworkListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkListResultIterator) Response() VirtualNetworkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkListResultIterator) Value() VirtualNetwork {
	if !iter.page.NotDone() {
		return VirtualNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkListResultIterator type.
func NewVirtualNetworkListResultIterator(page VirtualNetworkListResultPage) VirtualNetworkListResultIterator {
	return VirtualNetworkListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnlr VirtualNetworkListResult) IsEmpty() bool {
	return vnlr.Value == nil || len(*vnlr.Value) == 0
}

// virtualNetworkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnlr VirtualNetworkListResult) virtualNetworkListResultPreparer(ctx context.Context) (*http.Request, error) {
	if vnlr.NextLink == nil || len(to.String(vnlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnlr.NextLink)))
}

// VirtualNetworkListResultPage contains a page of VirtualNetwork values.
type VirtualNetworkListResultPage struct {
	fn   func(context.Context, VirtualNetworkListResult) (VirtualNetworkListResult, error)
	vnlr VirtualNetworkListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.vnlr)
	if err != nil {
		return err
	}
	page.vnlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkListResultPage) NotDone() bool {
	return !page.vnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkListResultPage) Response() VirtualNetworkListResult {
	return page.vnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkListResultPage) Values() []VirtualNetwork {
	if page.vnlr.IsEmpty() {
		return nil
	}
	return *page.vnlr.Value
}

// Creates a new instance of the VirtualNetworkListResultPage type.
func NewVirtualNetworkListResultPage(getNextPage func(context.Context, VirtualNetworkListResult) (VirtualNetworkListResult, error)) VirtualNetworkListResultPage {
	return VirtualNetworkListResultPage{fn: getNextPage}
}

// VirtualNetworkPropertiesFormat ...
type VirtualNetworkPropertiesFormat struct {
	// AddressSpace - The AddressSpace that contains an array of IP address ranges that can be used by subnets.
	AddressSpace *AddressSpace `json:"addressSpace,omitempty"`
	// DhcpOptions - The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
	DhcpOptions *DhcpOptions `json:"dhcpOptions,omitempty"`
	// Subnets - A list of subnets in a Virtual Network.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// ResourceGUID - The resourceGuid property of the Virtual Network resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VirtualNetworksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworksCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworksCreateOrUpdateFuture) Result(client VirtualNetworksClient) (vn VirtualNetwork, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.VirtualNetworksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vn.Response.Response, err = future.GetResult(sender); err == nil && vn.Response.Response.StatusCode != http.StatusNoContent {
		vn, err = client.CreateOrUpdateResponder(vn.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "network.VirtualNetworksCreateOrUpdateFuture", "Result", vn.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworksDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworksDeleteFuture) Result(client VirtualNetworksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.VirtualNetworksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("network.VirtualNetworksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VpnClientConfiguration vpnClientConfiguration for P2S client
type VpnClientConfiguration struct {
	// VpnClientAddressPool - Gets or sets the reference of the Address space resource which represents Address space for P2S VpnClient.
	VpnClientAddressPool *AddressSpace `json:"vpnClientAddressPool,omitempty"`
	// VpnClientRootCertificates - VpnClientRootCertificate for Virtual network gateway.
	VpnClientRootCertificates *[]VpnClientRootCertificate `json:"vpnClientRootCertificates,omitempty"`
	// VpnClientRevokedCertificates - VpnClientRevokedCertificate for Virtual network gateway.
	VpnClientRevokedCertificates *[]VpnClientRevokedCertificate `json:"vpnClientRevokedCertificates,omitempty"`
}

// VpnClientParameters vpnClientParameters
type VpnClientParameters struct {
	// ProcessorArchitecture - VPN client Processor Architecture. Possible values are: 'AMD64' and 'X86'. Possible values include: 'Amd64', 'X86'
	ProcessorArchitecture ProcessorArchitecture `json:"ProcessorArchitecture,omitempty"`
}

// VpnClientRevokedCertificate VPN client revoked certificate of virtual network gateway.
type VpnClientRevokedCertificate struct {
	*VpnClientRevokedCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VpnClientRevokedCertificate.
func (vcrc VpnClientRevokedCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcrc.VpnClientRevokedCertificatePropertiesFormat != nil {
		objectMap["properties"] = vcrc.VpnClientRevokedCertificatePropertiesFormat
	}
	if vcrc.Name != nil {
		objectMap["name"] = vcrc.Name
	}
	if vcrc.Etag != nil {
		objectMap["etag"] = vcrc.Etag
	}
	if vcrc.ID != nil {
		objectMap["id"] = vcrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VpnClientRevokedCertificate struct.
func (vcrc *VpnClientRevokedCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vpnClientRevokedCertificatePropertiesFormat VpnClientRevokedCertificatePropertiesFormat
				err = json.Unmarshal(*v, &vpnClientRevokedCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				vcrc.VpnClientRevokedCertificatePropertiesFormat = &vpnClientRevokedCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vcrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vcrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vcrc.ID = &ID
			}
		}
	}

	return nil
}

// VpnClientRevokedCertificatePropertiesFormat properties of the revoked VPN client certificate of virtual
// network gateway.
type VpnClientRevokedCertificatePropertiesFormat struct {
	// Thumbprint - The revoked VPN client certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ProvisioningState - The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VpnClientRootCertificate VPN client root certificate of virtual network gateway
type VpnClientRootCertificate struct {
	*VpnClientRootCertificatePropertiesFormat `json:"properties,omitempty"`
	// Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
	// Etag - A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource Identifier.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for VpnClientRootCertificate.
func (vcrc VpnClientRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcrc.VpnClientRootCertificatePropertiesFormat != nil {
		objectMap["properties"] = vcrc.VpnClientRootCertificatePropertiesFormat
	}
	if vcrc.Name != nil {
		objectMap["name"] = vcrc.Name
	}
	if vcrc.Etag != nil {
		objectMap["etag"] = vcrc.Etag
	}
	if vcrc.ID != nil {
		objectMap["id"] = vcrc.ID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VpnClientRootCertificate struct.
func (vcrc *VpnClientRootCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vpnClientRootCertificatePropertiesFormat VpnClientRootCertificatePropertiesFormat
				err = json.Unmarshal(*v, &vpnClientRootCertificatePropertiesFormat)
				if err != nil {
					return err
				}
				vcrc.VpnClientRootCertificatePropertiesFormat = &vpnClientRootCertificatePropertiesFormat
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vcrc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				vcrc.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vcrc.ID = &ID
			}
		}
	}

	return nil
}

// VpnClientRootCertificatePropertiesFormat properties of SSL certificates of application gateway
type VpnClientRootCertificatePropertiesFormat struct {
	// PublicCertData - Gets or sets the certificate public data
	PublicCertData *string `json:"publicCertData,omitempty"`
	// ProvisioningState - The provisioning state of the VPN client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}
