package workspaces

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// State enumerates the values for state.
type State string

const (
	// Deleted ...
	Deleted State = "Deleted"
	// Disabled ...
	Disabled State = "Disabled"
	// Enabled ...
	Enabled State = "Enabled"
	// Migrated ...
	Migrated State = "Migrated"
	// Registered ...
	Registered State = "Registered"
	// Unregistered ...
	Unregistered State = "Unregistered"
	// Updated ...
	Updated State = "Updated"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{Deleted, Disabled, Enabled, Migrated, Registered, Unregistered, Updated}
}

// WorkspaceType enumerates the values for workspace type.
type WorkspaceType string

const (
	// Anonymous ...
	Anonymous WorkspaceType = "Anonymous"
	// Free ...
	Free WorkspaceType = "Free"
	// PaidPremium ...
	PaidPremium WorkspaceType = "PaidPremium"
	// PaidStandard ...
	PaidStandard WorkspaceType = "PaidStandard"
	// Production ...
	Production WorkspaceType = "Production"
)

// PossibleWorkspaceTypeValues returns an array of possible values for the WorkspaceType const type.
func PossibleWorkspaceTypeValues() []WorkspaceType {
	return []WorkspaceType{Anonymous, Free, PaidPremium, PaidStandard, Production}
}
