// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/connection/v1/connection.proto

package connection

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Supported Cloud SQL database types.
type CloudSqlProperties_DatabaseType int32

const (
	// Unspecified database type.
	CloudSqlProperties_DATABASE_TYPE_UNSPECIFIED CloudSqlProperties_DatabaseType = 0
	// Cloud SQL for PostgreSQL.
	CloudSqlProperties_POSTGRES CloudSqlProperties_DatabaseType = 1
	// Cloud SQL for MySQL.
	CloudSqlProperties_MYSQL CloudSqlProperties_DatabaseType = 2
)

var CloudSqlProperties_DatabaseType_name = map[int32]string{
	0: "DATABASE_TYPE_UNSPECIFIED",
	1: "POSTGRES",
	2: "MYSQL",
}

var CloudSqlProperties_DatabaseType_value = map[string]int32{
	"DATABASE_TYPE_UNSPECIFIED": 0,
	"POSTGRES":                  1,
	"MYSQL":                     2,
}

func (x CloudSqlProperties_DatabaseType) String() string {
	return proto.EnumName(CloudSqlProperties_DatabaseType_name, int32(x))
}

func (CloudSqlProperties_DatabaseType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ec6e93d354cb74ee, []int{7, 0}
}

// The request for [ConnectionService.CreateConnection][google.cloud.bigquery.connection.v1.ConnectionService.CreateConnection].
type CreateConnectionRequest struct {
	// Required. Parent resource name.
	// Must be in the format `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Connection id that should be assigned to the created connection.
	ConnectionId string `protobuf:"bytes,2,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	// Required. Connection to create.
	Connection           *Connection `protobuf:"bytes,3,opt,name=connection,proto3" json:"connection,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateConnectionRequest) Reset()         { *m = CreateConnectionRequest{} }
func (m *CreateConnectionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateConnectionRequest) ProtoMessage()    {}
func (*CreateConnectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec6e93d354cb74ee, []int{0}
}

func (m *CreateConnectionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateConnectionRequest.Unmarshal(m, b)
}
func (m *CreateConnectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateConnectionRequest.Marshal(b, m, deterministic)
}
func (m *CreateConnectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateConnectionRequest.Merge(m, src)
}
func (m *CreateConnectionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateConnectionRequest.Size(m)
}
func (m *CreateConnectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateConnectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateConnectionRequest proto.InternalMessageInfo

func (m *CreateConnectionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateConnectionRequest) GetConnectionId() string {
	if m != nil {
		return m.ConnectionId
	}
	return ""
}

func (m *CreateConnectionRequest) GetConnection() *Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

// The request for [ConnectionService.GetConnection][google.cloud.bigquery.connection.v1.ConnectionService.GetConnection].
type GetConnectionRequest struct {
	// Required. Name of the requested connection, for example:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetConnectionRequest) Reset()         { *m = GetConnectionRequest{} }
func (m *GetConnectionRequest) String() string { return proto.CompactTextString(m) }
func (*GetConnectionRequest) ProtoMessage()    {}
func (*GetConnectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec6e93d354cb74ee, []int{1}
}

func (m *GetConnectionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetConnectionRequest.Unmarshal(m, b)
}
func (m *GetConnectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetConnectionRequest.Marshal(b, m, deterministic)
}
func (m *GetConnectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetConnectionRequest.Merge(m, src)
}
func (m *GetConnectionRequest) XXX_Size() int {
	return xxx_messageInfo_GetConnectionRequest.Size(m)
}
func (m *GetConnectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetConnectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetConnectionRequest proto.InternalMessageInfo

func (m *GetConnectionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [ConnectionService.ListConnections][google.cloud.bigquery.connection.v1.ConnectionService.ListConnections].
type ListConnectionsRequest struct {
	// Required. Parent resource name.
	// Must be in the form: `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListConnectionsRequest) Reset()         { *m = ListConnectionsRequest{} }
func (m *ListConnectionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListConnectionsRequest) ProtoMessage()    {}
func (*ListConnectionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec6e93d354cb74ee, []int{2}
}

func (m *ListConnectionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListConnectionsRequest.Unmarshal(m, b)
}
func (m *ListConnectionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListConnectionsRequest.Marshal(b, m, deterministic)
}
func (m *ListConnectionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListConnectionsRequest.Merge(m, src)
}
func (m *ListConnectionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListConnectionsRequest.Size(m)
}
func (m *ListConnectionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListConnectionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListConnectionsRequest proto.InternalMessageInfo

func (m *ListConnectionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListConnectionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListConnectionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for [ConnectionService.ListConnections][google.cloud.bigquery.connection.v1.ConnectionService.ListConnections].
type ListConnectionsResponse struct {
	// Next page token.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// List of connections.
	Connections          []*Connection `protobuf:"bytes,2,rep,name=connections,proto3" json:"connections,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ListConnectionsResponse) Reset()         { *m = ListConnectionsResponse{} }
func (m *ListConnectionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListConnectionsResponse) ProtoMessage()    {}
func (*ListConnectionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec6e93d354cb74ee, []int{3}
}

func (m *ListConnectionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListConnectionsResponse.Unmarshal(m, b)
}
func (m *ListConnectionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListConnectionsResponse.Marshal(b, m, deterministic)
}
func (m *ListConnectionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListConnectionsResponse.Merge(m, src)
}
func (m *ListConnectionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListConnectionsResponse.Size(m)
}
func (m *ListConnectionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListConnectionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListConnectionsResponse proto.InternalMessageInfo

func (m *ListConnectionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListConnectionsResponse) GetConnections() []*Connection {
	if m != nil {
		return m.Connections
	}
	return nil
}

// The request for [ConnectionService.UpdateConnection][google.cloud.bigquery.connection.v1.ConnectionService.UpdateConnection].
type UpdateConnectionRequest struct {
	// Required. Name of the connection to update, for example:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Connection containing the updated fields.
	Connection *Connection `protobuf:"bytes,2,opt,name=connection,proto3" json:"connection,omitempty"`
	// Required. Update mask for the connection fields to be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateConnectionRequest) Reset()         { *m = UpdateConnectionRequest{} }
func (m *UpdateConnectionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateConnectionRequest) ProtoMessage()    {}
func (*UpdateConnectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec6e93d354cb74ee, []int{4}
}

func (m *UpdateConnectionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConnectionRequest.Unmarshal(m, b)
}
func (m *UpdateConnectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConnectionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateConnectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConnectionRequest.Merge(m, src)
}
func (m *UpdateConnectionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateConnectionRequest.Size(m)
}
func (m *UpdateConnectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConnectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConnectionRequest proto.InternalMessageInfo

func (m *UpdateConnectionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateConnectionRequest) GetConnection() *Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

func (m *UpdateConnectionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request for [ConnectionService.DeleteConnectionRequest][].
type DeleteConnectionRequest struct {
	// Required. Name of the deleted connection, for example:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteConnectionRequest) Reset()         { *m = DeleteConnectionRequest{} }
func (m *DeleteConnectionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteConnectionRequest) ProtoMessage()    {}
func (*DeleteConnectionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec6e93d354cb74ee, []int{5}
}

func (m *DeleteConnectionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteConnectionRequest.Unmarshal(m, b)
}
func (m *DeleteConnectionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteConnectionRequest.Marshal(b, m, deterministic)
}
func (m *DeleteConnectionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteConnectionRequest.Merge(m, src)
}
func (m *DeleteConnectionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteConnectionRequest.Size(m)
}
func (m *DeleteConnectionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteConnectionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteConnectionRequest proto.InternalMessageInfo

func (m *DeleteConnectionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Configuration parameters to establish connection with an external data
// source, except the credential attributes.
type Connection struct {
	// The resource name of the connection in the form of:
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User provided display name for the connection.
	FriendlyName string `protobuf:"bytes,2,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// User provided description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Properties specific to the underlying data source.
	//
	// Types that are valid to be assigned to Properties:
	//	*Connection_CloudSql
	Properties isConnection_Properties `protobuf_oneof:"properties"`
	// Output only. The creation timestamp of the connection.
	CreationTime int64 `protobuf:"varint,5,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Output only. The last update timestamp of the connection.
	LastModifiedTime int64 `protobuf:"varint,6,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// Output only. True, if credential is configured for this connection.
	HasCredential        bool     `protobuf:"varint,7,opt,name=has_credential,json=hasCredential,proto3" json:"has_credential,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Connection) Reset()         { *m = Connection{} }
func (m *Connection) String() string { return proto.CompactTextString(m) }
func (*Connection) ProtoMessage()    {}
func (*Connection) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec6e93d354cb74ee, []int{6}
}

func (m *Connection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Connection.Unmarshal(m, b)
}
func (m *Connection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Connection.Marshal(b, m, deterministic)
}
func (m *Connection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connection.Merge(m, src)
}
func (m *Connection) XXX_Size() int {
	return xxx_messageInfo_Connection.Size(m)
}
func (m *Connection) XXX_DiscardUnknown() {
	xxx_messageInfo_Connection.DiscardUnknown(m)
}

var xxx_messageInfo_Connection proto.InternalMessageInfo

func (m *Connection) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Connection) GetFriendlyName() string {
	if m != nil {
		return m.FriendlyName
	}
	return ""
}

func (m *Connection) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type isConnection_Properties interface {
	isConnection_Properties()
}

type Connection_CloudSql struct {
	CloudSql *CloudSqlProperties `protobuf:"bytes,4,opt,name=cloud_sql,json=cloudSql,proto3,oneof"`
}

func (*Connection_CloudSql) isConnection_Properties() {}

func (m *Connection) GetProperties() isConnection_Properties {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *Connection) GetCloudSql() *CloudSqlProperties {
	if x, ok := m.GetProperties().(*Connection_CloudSql); ok {
		return x.CloudSql
	}
	return nil
}

func (m *Connection) GetCreationTime() int64 {
	if m != nil {
		return m.CreationTime
	}
	return 0
}

func (m *Connection) GetLastModifiedTime() int64 {
	if m != nil {
		return m.LastModifiedTime
	}
	return 0
}

func (m *Connection) GetHasCredential() bool {
	if m != nil {
		return m.HasCredential
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Connection) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Connection_CloudSql)(nil),
	}
}

// Connection properties specific to the Cloud SQL.
type CloudSqlProperties struct {
	// Cloud SQL instance ID in the form `project:location:instance`.
	InstanceId string `protobuf:"bytes,1,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Database name.
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// Type of the Cloud SQL database.
	Type CloudSqlProperties_DatabaseType `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.bigquery.connection.v1.CloudSqlProperties_DatabaseType" json:"type,omitempty"`
	// Input only. Cloud SQL credential.
	Credential           *CloudSqlCredential `protobuf:"bytes,4,opt,name=credential,proto3" json:"credential,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CloudSqlProperties) Reset()         { *m = CloudSqlProperties{} }
func (m *CloudSqlProperties) String() string { return proto.CompactTextString(m) }
func (*CloudSqlProperties) ProtoMessage()    {}
func (*CloudSqlProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec6e93d354cb74ee, []int{7}
}

func (m *CloudSqlProperties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudSqlProperties.Unmarshal(m, b)
}
func (m *CloudSqlProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudSqlProperties.Marshal(b, m, deterministic)
}
func (m *CloudSqlProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudSqlProperties.Merge(m, src)
}
func (m *CloudSqlProperties) XXX_Size() int {
	return xxx_messageInfo_CloudSqlProperties.Size(m)
}
func (m *CloudSqlProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudSqlProperties.DiscardUnknown(m)
}

var xxx_messageInfo_CloudSqlProperties proto.InternalMessageInfo

func (m *CloudSqlProperties) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CloudSqlProperties) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *CloudSqlProperties) GetType() CloudSqlProperties_DatabaseType {
	if m != nil {
		return m.Type
	}
	return CloudSqlProperties_DATABASE_TYPE_UNSPECIFIED
}

func (m *CloudSqlProperties) GetCredential() *CloudSqlCredential {
	if m != nil {
		return m.Credential
	}
	return nil
}

// Credential info for the Cloud SQL.
type CloudSqlCredential struct {
	// The username for the credential.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// The password for the credential.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudSqlCredential) Reset()         { *m = CloudSqlCredential{} }
func (m *CloudSqlCredential) String() string { return proto.CompactTextString(m) }
func (*CloudSqlCredential) ProtoMessage()    {}
func (*CloudSqlCredential) Descriptor() ([]byte, []int) {
	return fileDescriptor_ec6e93d354cb74ee, []int{8}
}

func (m *CloudSqlCredential) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudSqlCredential.Unmarshal(m, b)
}
func (m *CloudSqlCredential) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudSqlCredential.Marshal(b, m, deterministic)
}
func (m *CloudSqlCredential) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudSqlCredential.Merge(m, src)
}
func (m *CloudSqlCredential) XXX_Size() int {
	return xxx_messageInfo_CloudSqlCredential.Size(m)
}
func (m *CloudSqlCredential) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudSqlCredential.DiscardUnknown(m)
}

var xxx_messageInfo_CloudSqlCredential proto.InternalMessageInfo

func (m *CloudSqlCredential) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *CloudSqlCredential) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.bigquery.connection.v1.CloudSqlProperties_DatabaseType", CloudSqlProperties_DatabaseType_name, CloudSqlProperties_DatabaseType_value)
	proto.RegisterType((*CreateConnectionRequest)(nil), "google.cloud.bigquery.connection.v1.CreateConnectionRequest")
	proto.RegisterType((*GetConnectionRequest)(nil), "google.cloud.bigquery.connection.v1.GetConnectionRequest")
	proto.RegisterType((*ListConnectionsRequest)(nil), "google.cloud.bigquery.connection.v1.ListConnectionsRequest")
	proto.RegisterType((*ListConnectionsResponse)(nil), "google.cloud.bigquery.connection.v1.ListConnectionsResponse")
	proto.RegisterType((*UpdateConnectionRequest)(nil), "google.cloud.bigquery.connection.v1.UpdateConnectionRequest")
	proto.RegisterType((*DeleteConnectionRequest)(nil), "google.cloud.bigquery.connection.v1.DeleteConnectionRequest")
	proto.RegisterType((*Connection)(nil), "google.cloud.bigquery.connection.v1.Connection")
	proto.RegisterType((*CloudSqlProperties)(nil), "google.cloud.bigquery.connection.v1.CloudSqlProperties")
	proto.RegisterType((*CloudSqlCredential)(nil), "google.cloud.bigquery.connection.v1.CloudSqlCredential")
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/connection/v1/connection.proto", fileDescriptor_ec6e93d354cb74ee)
}

var fileDescriptor_ec6e93d354cb74ee = []byte{
	// 1325 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0x4f, 0x73, 0xdb, 0x44,
	0x14, 0xaf, 0x9c, 0xb4, 0x24, 0x2f, 0x4e, 0x63, 0x76, 0x4a, 0xe3, 0xba, 0x94, 0xba, 0xca, 0x0c,
	0xb8, 0x9e, 0x20, 0x4d, 0x42, 0x67, 0x3a, 0xa4, 0x2d, 0x53, 0x25, 0x71, 0xd2, 0x0c, 0x49, 0x71,
	0x65, 0xb7, 0x50, 0x06, 0x30, 0x1b, 0x69, 0xe3, 0x2c, 0xd5, 0xbf, 0x68, 0xd7, 0x09, 0x69, 0x26,
	0x1c, 0xf8, 0x0a, 0x70, 0xe4, 0x03, 0x00, 0x37, 0xce, 0x1c, 0x19, 0x2e, 0x70, 0x82, 0xde, 0x32,
	0x1c, 0x7a, 0xe8, 0x81, 0xe1, 0x23, 0xc0, 0x85, 0xd1, 0x4a, 0xb2, 0x64, 0x25, 0x6d, 0xed, 0x50,
	0x6e, 0xde, 0xf7, 0x7b, 0xfb, 0xfe, 0xfc, 0xde, 0x7b, 0xfb, 0x64, 0xb8, 0xd2, 0x76, 0xdd, 0xb6,
	0x45, 0x54, 0xc3, 0x72, 0x3b, 0xa6, 0xba, 0x4e, 0xdb, 0x5b, 0x1d, 0xe2, 0xef, 0xaa, 0x86, 0xeb,
	0x38, 0xc4, 0xe0, 0xd4, 0x75, 0xd4, 0xed, 0x99, 0xd4, 0x49, 0xf1, 0x7c, 0x97, 0xbb, 0x68, 0x2a,
	0xbc, 0xa5, 0x88, 0x5b, 0x4a, 0x7c, 0x4b, 0x49, 0xe9, 0x6d, 0xcf, 0x94, 0x5e, 0x8d, 0x4c, 0x63,
	0x8f, 0xaa, 0xd8, 0x71, 0x5c, 0x8e, 0x03, 0x84, 0x85, 0x26, 0x4a, 0x93, 0x29, 0xd4, 0xb0, 0x28,
	0x71, 0x78, 0x04, 0x5c, 0x4c, 0x01, 0x1b, 0x94, 0x58, 0x66, 0x6b, 0x9d, 0x6c, 0xe2, 0x6d, 0xea,
	0xfa, 0x91, 0xc2, 0xb9, 0x94, 0x82, 0x4f, 0x98, 0xdb, 0xf1, 0x0d, 0x12, 0x41, 0xaf, 0x45, 0x10,
	0xc5, 0x76, 0x10, 0x37, 0xc5, 0x76, 0xcb, 0x73, 0x2d, 0x6a, 0xec, 0x46, 0x78, 0xa9, 0x17, 0xef,
	0xc1, 0xce, 0x47, 0x98, 0x38, 0xad, 0x77, 0x36, 0x54, 0x62, 0x7b, 0x3c, 0x06, 0xcb, 0x59, 0x30,
	0x8c, 0xcc, 0xc6, 0xec, 0x41, 0xc6, 0x75, 0x57, 0x63, 0xc7, 0xc7, 0x9e, 0x47, 0xfc, 0x28, 0x5f,
	0xf9, 0x0f, 0x09, 0x26, 0x17, 0x7c, 0x82, 0x39, 0x59, 0xe8, 0xb2, 0xa4, 0x93, 0xad, 0x0e, 0x61,
	0x1c, 0x69, 0x70, 0xca, 0xc3, 0x3e, 0x71, 0x78, 0x51, 0x2a, 0x4b, 0x95, 0xd1, 0xf9, 0xcb, 0x8f,
	0xb5, 0xdc, 0xdf, 0xda, 0x14, 0x5c, 0xb2, 0x5c, 0x23, 0x22, 0x2d, 0xb4, 0x8e, 0x3d, 0xca, 0x14,
	0xc3, 0xb5, 0xd5, 0xd5, 0x08, 0xd0, 0xa3, 0x8b, 0xa8, 0x02, 0xe3, 0x09, 0xfb, 0x2d, 0x6a, 0x16,
	0x73, 0xc2, 0xd2, 0xd0, 0x63, 0x4d, 0xd2, 0xf3, 0x09, 0xb2, 0x62, 0xa2, 0x26, 0x40, 0x72, 0x2e,
	0x0e, 0x95, 0xa5, 0xca, 0xd8, 0xac, 0xaa, 0xf4, 0x51, 0x50, 0x25, 0x09, 0x3c, 0xb0, 0x9b, 0xd3,
	0x53, 0x76, 0xe4, 0x4f, 0xe1, 0xcc, 0x32, 0xe1, 0x87, 0x53, 0xbb, 0x05, 0xc3, 0x0e, 0xb6, 0x49,
	0x94, 0xd8, 0x15, 0x91, 0x98, 0x02, 0xd3, 0xb1, 0x87, 0x94, 0x83, 0x4c, 0x86, 0x29, 0x53, 0xc2,
	0x82, 0xfc, 0x8d, 0x04, 0x67, 0x57, 0x29, 0x4b, 0xf9, 0x60, 0x2f, 0x90, 0xbf, 0x32, 0x8c, 0x7a,
	0xb8, 0x4d, 0x5a, 0x8c, 0x3e, 0x24, 0xc5, 0xe1, 0xb2, 0x54, 0x39, 0x19, 0xe6, 0x38, 0x12, 0x48,
	0x1b, 0xf4, 0x21, 0x41, 0x17, 0x00, 0x84, 0x06, 0x77, 0x1f, 0x90, 0x90, 0xb7, 0x51, 0x5d, 0xdc,
	0x69, 0x06, 0x02, 0xf9, 0x6b, 0x09, 0x26, 0x0f, 0x85, 0xc7, 0x3c, 0xd7, 0x61, 0x04, 0xbd, 0x0e,
	0x13, 0x0e, 0xf9, 0x9c, 0xb7, 0x52, 0xf7, 0x45, 0xa0, 0xfa, 0x78, 0x20, 0xae, 0xc7, 0x36, 0xd0,
	0x1d, 0x18, 0x4b, 0x08, 0x61, 0xc5, 0x5c, 0x79, 0xe8, 0x18, 0xb5, 0xd1, 0xd3, 0x36, 0xe4, 0x7f,
	0x24, 0x98, 0xbc, 0xeb, 0x99, 0x47, 0xb6, 0xdd, 0x0b, 0xab, 0x4d, 0xa6, 0xa7, 0x72, 0x2f, 0xa6,
	0xa7, 0xd0, 0x4d, 0x18, 0xeb, 0x88, 0xd0, 0xc5, 0x9c, 0x45, 0xad, 0x5a, 0x8a, 0xcd, 0xc6, 0x83,
	0xa6, 0x2c, 0x05, 0xa3, 0xb8, 0x86, 0xd9, 0x83, 0xc8, 0x42, 0x78, 0x27, 0x10, 0xc8, 0x06, 0x4c,
	0x2e, 0x12, 0x8b, 0xfc, 0xaf, 0xc9, 0xcb, 0xbf, 0x0e, 0x01, 0x24, 0x42, 0x84, 0xd2, 0x86, 0x23,
	0x7e, 0xa6, 0x60, 0x7c, 0xc3, 0xa7, 0xc4, 0x31, 0xad, 0xdd, 0x96, 0x00, 0xc5, 0x74, 0xea, 0xf9,
	0x58, 0x78, 0x3b, 0x50, 0x2a, 0xc3, 0x98, 0x49, 0x98, 0xe1, 0x53, 0xaf, 0x3b, 0x99, 0xa3, 0x7a,
	0x5a, 0x84, 0xee, 0xc1, 0xa8, 0x20, 0xb3, 0xc5, 0xb6, 0x2c, 0xd1, 0xa4, 0x63, 0xb3, 0x57, 0xfb,
	0x63, 0x39, 0x00, 0x1b, 0x5b, 0x56, 0xdd, 0x77, 0x3d, 0xe2, 0x73, 0x4a, 0xd8, 0xad, 0x13, 0xfa,
	0x88, 0x11, 0x49, 0xc5, 0xe3, 0x11, 0x3c, 0x4d, 0xc1, 0xd3, 0xc1, 0xa9, 0x4d, 0x8a, 0x27, 0xcb,
	0x52, 0x65, 0x28, 0xa0, 0x73, 0x48, 0xcf, 0xc7, 0x48, 0x93, 0xda, 0x04, 0xcd, 0x00, 0xb2, 0x30,
	0xe3, 0x2d, 0xdb, 0x35, 0xe9, 0x06, 0x25, 0x66, 0xa8, 0x7e, 0x2a, 0x51, 0x2f, 0x04, 0xf0, 0x5a,
	0x84, 0x8a, 0x2b, 0x55, 0x38, 0xbd, 0x89, 0x59, 0xcb, 0xf0, 0x89, 0x49, 0x1c, 0x4e, 0xb1, 0x55,
	0x7c, 0xa9, 0x2c, 0x55, 0x46, 0x42, 0xf5, 0xf1, 0x4d, 0xcc, 0x16, 0xba, 0xc8, 0x1c, 0xfb, 0x4b,
	0xf3, 0x06, 0xab, 0x01, 0xba, 0xe9, 0xf9, 0xee, 0x67, 0xc4, 0xe0, 0x4c, 0xdd, 0x8b, 0x7e, 0xed,
	0xab, 0xdd, 0xb1, 0x57, 0xf7, 0xe2, 0x9f, 0xfb, 0xa9, 0x25, 0xc6, 0xd4, 0xbd, 0xe4, 0xb0, 0x3f,
	0x9f, 0x07, 0xf0, 0xba, 0xbc, 0xc8, 0xbf, 0xe5, 0x00, 0x1d, 0xa6, 0x0b, 0x5d, 0x84, 0x31, 0xea,
	0x30, 0x8e, 0x1d, 0x83, 0x04, 0xaf, 0x6b, 0x58, 0x5c, 0x88, 0x45, 0x2b, 0x26, 0x2a, 0xc1, 0x88,
	0x89, 0x39, 0x5e, 0xc7, 0x2c, 0xae, 0x6e, 0xf7, 0x8c, 0x3e, 0x80, 0x61, 0xbe, 0xeb, 0x11, 0x51,
	0xd2, 0xd3, 0xb3, 0x8b, 0xc7, 0x2c, 0x99, 0xb2, 0x18, 0xd9, 0x6b, 0xee, 0x7a, 0x44, 0x17, 0x16,
	0xd1, 0x47, 0x00, 0x29, 0x62, 0x8f, 0xd3, 0x12, 0x09, 0xfb, 0x41, 0x45, 0x86, 0xf5, 0x94, 0x3d,
	0x79, 0x09, 0xf2, 0x69, 0x9f, 0xe8, 0x02, 0x9c, 0x5b, 0xd4, 0x9a, 0xda, 0xbc, 0xd6, 0xa8, 0xb5,
	0x9a, 0xf7, 0xeb, 0xb5, 0xd6, 0xdd, 0xdb, 0x8d, 0x7a, 0x6d, 0x61, 0x65, 0x69, 0xa5, 0xb6, 0x58,
	0x38, 0x81, 0xf2, 0x30, 0x52, 0x7f, 0xaf, 0xd1, 0x5c, 0xd6, 0x6b, 0x8d, 0x82, 0x84, 0x46, 0xe1,
	0xe4, 0xda, 0xfd, 0xc6, 0x9d, 0xd5, 0x42, 0x4e, 0x5e, 0x4d, 0x28, 0x4d, 0xdc, 0x05, 0x8c, 0x75,
	0x18, 0xf1, 0x53, 0xc3, 0xd2, 0x3d, 0x07, 0x98, 0x87, 0x19, 0xdb, 0x71, 0x7d, 0x33, 0x66, 0x33,
	0x3e, 0xcf, 0xfe, 0x34, 0x0e, 0x2f, 0x27, 0x0d, 0xd0, 0x20, 0xfe, 0x36, 0x35, 0x08, 0xfa, 0x53,
	0x82, 0x42, 0x76, 0xbf, 0xa2, 0xeb, 0xfd, 0x51, 0x71, 0xf4, 0x5a, 0x2e, 0x0d, 0xfa, 0x82, 0xc9,
	0xe4, 0x40, 0xbb, 0x18, 0xee, 0x93, 0xe9, 0x44, 0x67, 0xba, 0x67, 0x2f, 0x7f, 0xf9, 0xe8, 0xc9,
	0x57, 0xb9, 0x1b, 0xb2, 0x1a, 0x7c, 0x7e, 0xec, 0x85, 0xba, 0x37, 0xba, 0x1d, 0x5c, 0x4d, 0x75,
	0x6e, 0xb5, 0xa7, 0x63, 0xe7, 0xd2, 0xef, 0xe2, 0x8f, 0x12, 0x8c, 0xf7, 0x2c, 0x5b, 0xf4, 0x76,
	0x5f, 0x91, 0x1e, 0xb5, 0xa0, 0x07, 0x4f, 0xf2, 0x9d, 0x03, 0x4d, 0x3c, 0x6a, 0x22, 0x93, 0x19,
	0x14, 0x66, 0x12, 0x08, 0x9e, 0x92, 0x47, 0xcf, 0xe0, 0x55, 0xf7, 0xd1, 0xcf, 0x12, 0x4c, 0x64,
	0x16, 0x25, 0xba, 0xd6, 0x57, 0x10, 0x47, 0x6f, 0xff, 0xd2, 0xf5, 0xe3, 0x5d, 0x0e, 0x77, 0xb3,
	0x7c, 0xb5, 0x27, 0x8f, 0xfe, 0x2b, 0x82, 0x9e, 0x48, 0x50, 0xc8, 0x6e, 0xd6, 0x3e, 0x1b, 0xee,
	0x29, 0x0b, 0x79, 0xf0, 0x5a, 0xe0, 0x03, 0xed, 0x7c, 0x40, 0x7d, 0xba, 0xdd, 0x52, 0x2b, 0x33,
	0x6c, 0xb6, 0xd9, 0x41, 0x4b, 0xd4, 0xd3, 0x6c, 0xdf, 0x4a, 0x50, 0xc8, 0xee, 0xd0, 0x3e, 0xd3,
	0x7c, 0xca, 0xea, 0x2d, 0x9d, 0x3d, 0xb4, 0xc2, 0x6b, 0xc1, 0xa7, 0x76, 0xa6, 0xb3, 0xaa, 0x03,
	0x77, 0xd6, 0x77, 0x12, 0xe4, 0x97, 0x09, 0x5f, 0xc1, 0x76, 0x5d, 0x7c, 0xd8, 0x23, 0x39, 0x76,
	0x44, 0xb1, 0x1d, 0x0d, 0x40, 0x17, 0x8c, 0x83, 0x79, 0x25, 0xa3, 0x13, 0xa2, 0xf2, 0x27, 0x07,
	0x5a, 0x21, 0xfe, 0x73, 0x31, 0xed, 0x8a, 0xf5, 0xcb, 0x44, 0x5c, 0x35, 0xf9, 0xa6, 0x88, 0x2b,
	0x06, 0xfb, 0xa4, 0xb4, 0x9d, 0x72, 0x3d, 0x27, 0x55, 0x03, 0x5a, 0xf3, 0x8d, 0x67, 0xc5, 0xda,
	0xe8, 0x3f, 0xd6, 0x8f, 0x0f, 0xb4, 0x89, 0x6e, 0xac, 0xe1, 0x7f, 0x9a, 0xff, 0x12, 0x2a, 0xcb,
	0x84, 0xfa, 0x48, 0x02, 0xd4, 0x24, 0x4c, 0x08, 0x89, 0x6f, 0x53, 0xc6, 0x44, 0xff, 0x57, 0x32,
	0xc1, 0x1c, 0x56, 0x89, 0xc3, 0xbe, 0xdc, 0x87, 0x66, 0x34, 0x8d, 0x9b, 0x07, 0xda, 0x99, 0x24,
	0x95, 0x44, 0x41, 0xe4, 0xf3, 0xae, 0xbc, 0x74, 0x9c, 0x7c, 0xf8, 0x21, 0x77, 0x73, 0x52, 0xb5,
	0xf4, 0xc5, 0x2f, 0xda, 0xa5, 0xe7, 0x7e, 0x68, 0xfc, 0xae, 0xbd, 0xbf, 0xc9, 0xb9, 0xc7, 0xe6,
	0x54, 0x75, 0x67, 0x67, 0x27, 0xfb, 0x15, 0x82, 0x3b, 0x7c, 0xb3, 0xfb, 0x97, 0x79, 0xfa, 0x79,
	0x8a, 0x62, 0x54, 0xde, 0xf4, 0x2c, 0xcc, 0x37, 0x5c, 0xdf, 0x9e, 0xff, 0x41, 0x82, 0x37, 0x0c,
	0xd7, 0xee, 0x67, 0x90, 0xe6, 0x27, 0x92, 0x19, 0xaa, 0x07, 0x23, 0x53, 0x97, 0x3e, 0x5c, 0x8b,
	0xee, 0xb5, 0x5d, 0x0b, 0x3b, 0x6d, 0xc5, 0xf5, 0xdb, 0x6a, 0x9b, 0x38, 0x62, 0xa0, 0xd4, 0xc4,
	0xfb, 0x33, 0xff, 0xd6, 0x5f, 0x4b, 0x4e, 0xdf, 0xe7, 0xa6, 0x96, 0x43, 0x7b, 0x62, 0x4f, 0x2b,
	0xf3, 0xb4, 0x7d, 0x47, 0xc4, 0x91, 0x38, 0x56, 0xee, 0xcd, 0xac, 0x9f, 0x12, 0xf6, 0xdf, 0xfa,
	0x37, 0x00, 0x00, 0xff, 0xff, 0x16, 0x96, 0xdc, 0x9d, 0x35, 0x10, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConnectionServiceClient is the client API for ConnectionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConnectionServiceClient interface {
	// Creates a new connection.
	CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Returns specified connection.
	GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Returns a list of connections in the given project.
	ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error)
	// Updates the specified connection. For security reasons, also resets
	// credential if connection properties are in the update field mask.
	UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Deletes connection and associated credential.
	DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	//
	// Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type connectionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConnectionServiceClient(cc grpc.ClientConnInterface) ConnectionServiceClient {
	return &connectionServiceClient{cc}
}

func (c *connectionServiceClient) CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/CreateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/GetConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error) {
	out := new(ListConnectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/ListConnections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/UpdateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/DeleteConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *connectionServiceClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.connection.v1.ConnectionService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConnectionServiceServer is the server API for ConnectionService service.
type ConnectionServiceServer interface {
	// Creates a new connection.
	CreateConnection(context.Context, *CreateConnectionRequest) (*Connection, error)
	// Returns specified connection.
	GetConnection(context.Context, *GetConnectionRequest) (*Connection, error)
	// Returns a list of connections in the given project.
	ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error)
	// Updates the specified connection. For security reasons, also resets
	// credential if connection properties are in the update field mask.
	UpdateConnection(context.Context, *UpdateConnectionRequest) (*Connection, error)
	// Deletes connection and associated credential.
	DeleteConnection(context.Context, *DeleteConnectionRequest) (*empty.Empty, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	//
	// Can return Public Errors: NOT_FOUND, INVALID_ARGUMENT and PERMISSION_DENIED
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedConnectionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConnectionServiceServer struct {
}

func (*UnimplementedConnectionServiceServer) CreateConnection(ctx context.Context, req *CreateConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) GetConnection(ctx context.Context, req *GetConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) ListConnections(ctx context.Context, req *ListConnectionsRequest) (*ListConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnections not implemented")
}
func (*UnimplementedConnectionServiceServer) UpdateConnection(ctx context.Context, req *UpdateConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) DeleteConnection(ctx context.Context, req *DeleteConnectionRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnection not implemented")
}
func (*UnimplementedConnectionServiceServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedConnectionServiceServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedConnectionServiceServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterConnectionServiceServer(s *grpc.Server, srv ConnectionServiceServer) {
	s.RegisterService(&_ConnectionService_serviceDesc, srv)
}

func _ConnectionService_CreateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).CreateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/CreateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).CreateConnection(ctx, req.(*CreateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_GetConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).GetConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/GetConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).GetConnection(ctx, req.(*GetConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_ListConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).ListConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/ListConnections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).ListConnections(ctx, req.(*ListConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_UpdateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).UpdateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/UpdateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).UpdateConnection(ctx, req.(*UpdateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_DeleteConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).DeleteConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/DeleteConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).DeleteConnection(ctx, req.(*DeleteConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConnectionService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConnectionServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.connection.v1.ConnectionService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConnectionServiceServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConnectionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.connection.v1.ConnectionService",
	HandlerType: (*ConnectionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConnection",
			Handler:    _ConnectionService_CreateConnection_Handler,
		},
		{
			MethodName: "GetConnection",
			Handler:    _ConnectionService_GetConnection_Handler,
		},
		{
			MethodName: "ListConnections",
			Handler:    _ConnectionService_ListConnections_Handler,
		},
		{
			MethodName: "UpdateConnection",
			Handler:    _ConnectionService_UpdateConnection_Handler,
		},
		{
			MethodName: "DeleteConnection",
			Handler:    _ConnectionService_DeleteConnection_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _ConnectionService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _ConnectionService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ConnectionService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/connection/v1/connection.proto",
}
