<h1 align="center">
  ✍️ Nanopub cross-platform toolkit ⚔️
</h1>

<p align="center">
    <a href="https://crates.io/crates/nanopub">
        <img alt="crates.io" src="https://img.shields.io/crates/v/nanopub.svg" />
    </a>
    <a href="https://www.npmjs.com/package/@nanopub/sign">
        <img alt="npm" src="https://img.shields.io/npm/v/@nanopub/sign" />
    </a>
    <a href="https://pypi.org/project/nanopub-sign">
        <img alt="PyPI" src="https://img.shields.io/pypi/v/nanopub-sign" />
    </a>
</p>

<p align="center">
    <a href="https://github.com/vemonet/nanopub-rs/actions/workflows/test.yml">
        <img alt="Test" src="https://github.com/vemonet/nanopub-rs/actions/workflows/test.yml/badge.svg" />
    </a>
    <a href="https://github.com/vemonet/nanopub-rs/actions/workflows/build.yml">
        <img alt="Build" src="https://github.com/vemonet/nanopub-rs/actions/workflows/build.yml/badge.svg" />
    </a>
    <a href="https://docs.rs/nanopub">
        <img alt="crates" src="https://docs.rs/nanopub/badge.svg" />
    </a>
    <a href="https://deps.rs/repo/github/vemonet/nanopub-rs">
        <img src="https://deps.rs/repo/github/vemonet/nanopub-rs/status.svg" alt="Dependency status" />
    </a>
    <a href="https://github.com/vemonet/nanopub-rs/blob/main/LICENSE">
        <img alt="MIT license" src="https://img.shields.io/badge/License-MIT-brightgreen.svg" />
    </a>
    <a href="https://codecov.io/gh/vemonet/nanopub-rs/branch/main">
        <img src="https://codecov.io/gh/vemonet/nanopub-rs/branch/main/graph/badge.svg" alt="Codecov status" />
    </a>
</p>

This project aims to provide a comprehensive cross-platform toolkit to sign, publish, and check **[Nanopublications](https://nanopub.net)**.

It is packaged to be used easily through various popular interfaces:

- ⌨️ Binary with a CLI for use in the terminal
- 🦀 Crate `nanopub` for Rust
- 🐍 Pip package `nanopub-sign` for Python
- 📦️ NPM package `@nanopub/sign` for JavaScript (compiled to WebAssembly) in the browser, or with NodeJS

On all platforms:

- 🐧 Linux
- 🍎 MacOS
- 🪟 Windows
- 🦊 Web browsers

## 📖 Documentation

Checkout the **[documentation website](https://vemonet.github.io/nanopub-rs)** for more details on how to install and use it.

## 🏔️ Changelog

Version history is recorded in the [CHANGELOG.md](https://github.com/vemonet/nanopub-rs/blob/main/CHANGELOG.md).
